/*
 * Decompiled with CFR 0.152.
 */
package lumien.loadingprofiler.profiler;

import java.util.HashMap;
import java.util.Stack;
import net.minecraftforge.fml.common.asm.ASMTransformerWrapper;

public class TransformerProfiler {
    static TransformerProfiler INSTANCE;
    HashMap<ASMTransformerWrapper.TransformerWrapper, Long> times = new HashMap();
    Stack<ASMTransformerWrapper.TransformerWrapper> transformerStack = new Stack();
    Stack<Long> timeStack = new Stack();
    Stack<String> classStack = new Stack();
    HashMap<String, Long> classTimes = new HashMap();
    long nestedTime;
    boolean transformerRan = false;
    public static boolean enabled;

    private TransformerProfiler() {
    }

    private void logPre(ASMTransformerWrapper.TransformerWrapper transformer, String transformedName) {
        if (this.transformerStack.isEmpty()) {
            this.nestedTime = System.nanoTime();
            this.transformerRan = true;
        }
        this.classStack.push(transformedName);
        this.transformerStack.push(transformer);
        this.timeStack.push(System.nanoTime());
    }

    private void logPost(ASMTransformerWrapper.TransformerWrapper transformer, String transformedName) {
        long currentTimeDif = System.nanoTime() - this.timeStack.pop();
        ASMTransformerWrapper.TransformerWrapper currentTransformer = this.transformerStack.pop();
        String className = this.classStack.pop();
        if (this.transformerStack.isEmpty()) {
            this.nestedTime = System.nanoTime() - this.nestedTime;
        }
        for (int i = 0; i < this.timeStack.size(); ++i) {
            this.timeStack.set(i, (Long)this.timeStack.get(i) + currentTimeDif);
        }
        if (!className.equals(transformedName)) {
            System.out.println("What");
        } else if (this.classTimes.containsKey(className)) {
            this.classTimes.put(className, this.classTimes.get(className) + currentTimeDif);
        } else {
            this.classTimes.put(className, currentTimeDif);
        }
        if (currentTransformer != transformer) {
            System.out.println("What");
        } else if (this.times.containsKey(transformer)) {
            this.times.put(transformer, currentTimeDif + this.times.get(transformer));
        } else {
            this.times.put(transformer, currentTimeDif);
        }
    }

    public static void preTransform(ASMTransformerWrapper.TransformerWrapper transformer, String transformedName) {
        if (enabled) {
            TransformerProfiler.getProfiler().logPre(transformer, transformedName);
        }
    }

    public static void postTransform(ASMTransformerWrapper.TransformerWrapper transformer, String transformedName) {
        if (enabled) {
            TransformerProfiler.getProfiler().logPost(transformer, transformedName);
        }
    }

    public static TransformerProfiler getProfiler() {
        if (INSTANCE == null) {
            INSTANCE = new TransformerProfiler();
        }
        return INSTANCE;
    }

    public HashMap<ASMTransformerWrapper.TransformerWrapper, Long> getTimes() {
        return this.times;
    }

    public HashMap<String, Long> getClassTimes() {
        return this.classTimes;
    }

    static {
        enabled = true;
    }
}

