/*
 * Decompiled with CFR 0.152.
 */
package lumien.loadingprofiler;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import lumien.loadingprofiler.profiler.ModProfileResult;
import lumien.loadingprofiler.profiler.ModProfiler;
import lumien.loadingprofiler.profiler.TransformerProfileResult;
import lumien.loadingprofiler.profiler.TransformerProfiler;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.asm.ASMTransformerWrapper;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(name="LoadingProfiler", version="1.1", modid="loadingprofiler", acceptedMinecraftVersions="[1.12]")
public class LoadingProfiler {
    Logger logger;
    PrintWriter printWriter;
    long modThreshold;
    long transformerThreshold;
    long classThreshold;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        this.modThreshold = config.get("Settings", "Mod-Threshold", 0, "Any numbers higher than this will appear in the mod profiling results").getInt();
        this.transformerThreshold = config.get("Settings", "Transformer-Treshold", 20, "Any numbers higher than this will appear in the transformer specific profiling results").getInt();
        this.classThreshold = config.get("Settings", "Class-Treshold", 20, "Any numbers higher than this will appear in the class specific profiling results").getInt();
        if (config.hasChanged()) {
            config.save();
        }
    }

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent event) {
        TransformerProfiler.enabled = false;
        this.logger = LogManager.getLogger((String)"LoadingProfiler");
        File logFile = new File("loading-log.log");
        if (logFile.exists()) {
            logFile.delete();
            try {
                logFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            this.printWriter = new PrintWriter(logFile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        if (this.printWriter != null) {
            this.write("Mod Loading Profiling Results:");
            this.logModResults(this.printWriter);
            this.write("Class Transformer Profiling Results:");
            this.logTransformerResults(this.printWriter);
            this.printWriter.close();
        }
    }

    private void write(String text) {
        this.printWriter.write(text + "\n");
        this.logger.log(Level.DEBUG, text);
    }

    private void logTransformerResults(PrintWriter printWriter) {
        HashMap<ASMTransformerWrapper.TransformerWrapper, Long> times = TransformerProfiler.getProfiler().getTimes();
        ArrayList<TransformerProfileResult> results = new ArrayList<TransformerProfileResult>();
        for (Map.Entry<ASMTransformerWrapper.TransformerWrapper, Long> entry : times.entrySet()) {
            results.add(new TransformerProfileResult(entry.getKey(), entry.getValue()));
        }
        Collections.sort(results);
        Map<String, Long> classResults = LoadingProfiler.sortByValue(TransformerProfiler.getProfiler().getClassTimes());
        this.write("   Transformer Specific");
        long total = 0L;
        for (TransformerProfileResult result : results) {
            String className = result.transformer.toString();
            long time = result.time / 1000000L;
            if (time > this.transformerThreshold) {
                String transformerName = className.substring(className.indexOf("(") + 1, className.indexOf(","));
                this.write("      " + transformerName + ": " + time + "ms");
            }
            total += result.time;
        }
        long total2 = 0L;
        this.write("   Class Specific");
        for (Map.Entry<String, Long> entry : classResults.entrySet()) {
            long time = entry.getValue() / 1000000L;
            if (time <= this.classThreshold) continue;
            this.write("      " + entry.getKey() + ": " + time + "ms");
        }
        this.write("   Total: " + total / 1000000L + "ms");
    }

    private void logModResults(PrintWriter printWriter) {
        long time;
        Collections.sort(ModProfiler.getProfiler().constructing);
        Collections.sort(ModProfiler.getProfiler().preInit);
        Collections.sort(ModProfiler.getProfiler().init);
        Collections.sort(ModProfiler.getProfiler().postInit);
        ArrayList<ModProfileResult> totalTimes = this.calculateTotals(ModProfiler.getProfiler().constructing, ModProfiler.getProfiler().preInit, ModProfiler.getProfiler().init, ModProfiler.getProfiler().postInit);
        Collections.sort(totalTimes);
        this.write("   Constructing");
        for (ModProfileResult result : ModProfiler.getProfiler().constructing) {
            time = result.time / 1000000L;
            if (time <= this.modThreshold) continue;
            this.write("      " + result.modContainer.getModId() + ": " + time + "ms");
        }
        this.write("   PreInitialization");
        for (ModProfileResult result : ModProfiler.getProfiler().preInit) {
            time = result.time / 1000000L;
            if (time <= this.modThreshold) continue;
            this.write("      " + result.modContainer.getModId() + ": " + time + "ms");
        }
        this.write("   Initialization");
        for (ModProfileResult result : ModProfiler.getProfiler().init) {
            time = result.time / 1000000L;
            if (time <= this.modThreshold) continue;
            this.write("      " + result.modContainer.getModId() + ": " + time + "ms");
        }
        this.write("   PostInitialization");
        for (ModProfileResult result : ModProfiler.getProfiler().postInit) {
            time = result.time / 1000000L;
            if (time <= this.modThreshold) continue;
            this.write("      " + result.modContainer.getModId() + ": " + time + "ms");
        }
        this.write("   Total Time");
        for (ModProfileResult result : totalTimes) {
            time = result.time / 1000000L;
            this.write("      " + result.modContainer.getModId() + ": " + time + "ms");
        }
    }

    private ArrayList<ModProfileResult> calculateTotals(ArrayList<ModProfileResult> constructing, ArrayList<ModProfileResult> preInit, ArrayList<ModProfileResult> init, ArrayList<ModProfileResult> postInit) {
        HashMap<ModContainer, Long> timeMap = new HashMap<ModContainer, Long>();
        for (ModProfileResult fr : constructing) {
            if (timeMap.containsKey(fr.modContainer)) {
                timeMap.put(fr.modContainer, (Long)timeMap.get(fr.modContainer) + fr.time);
                continue;
            }
            timeMap.put(fr.modContainer, fr.time);
        }
        for (ModProfileResult fr : preInit) {
            if (timeMap.containsKey(fr.modContainer)) {
                timeMap.put(fr.modContainer, (Long)timeMap.get(fr.modContainer) + fr.time);
                continue;
            }
            timeMap.put(fr.modContainer, fr.time);
        }
        for (ModProfileResult fr : init) {
            if (timeMap.containsKey(fr.modContainer)) {
                timeMap.put(fr.modContainer, (Long)timeMap.get(fr.modContainer) + fr.time);
                continue;
            }
            timeMap.put(fr.modContainer, fr.time);
        }
        for (ModProfileResult fr : postInit) {
            if (timeMap.containsKey(fr.modContainer)) {
                timeMap.put(fr.modContainer, (Long)timeMap.get(fr.modContainer) + fr.time);
                continue;
            }
            timeMap.put(fr.modContainer, fr.time);
        }
        ArrayList<ModProfileResult> results = new ArrayList<ModProfileResult>();
        for (Map.Entry entry : timeMap.entrySet()) {
            results.add(new ModProfileResult((ModContainer)entry.getKey(), (Long)entry.getValue()));
        }
        return results;
    }

    public static <K, V extends Comparable<? super V>> Map<K, V> sortByValue(Map<K, V> map) {
        LinkedList<Map.Entry<K, V>> list = new LinkedList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
                return ((Comparable)o2.getValue()).compareTo(o1.getValue());
            }
        });
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }
}

