/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.util.states.factory;

import com.carpentersblocks.block.IStateImplementor;
import com.carpentersblocks.tileentity.CbTileEntity;
import com.carpentersblocks.util.states.State;
import com.carpentersblocks.util.states.StatePart;
import com.carpentersblocks.util.states.StateUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;

public abstract class AbstractState {
    protected CbTileEntity _cbTileEntity;
    protected State _state;

    public AbstractState(CbTileEntity cbTileEntity) {
        this._cbTileEntity = cbTileEntity;
        IStateImplementor impl = (IStateImplementor)cbTileEntity.func_145838_q();
        this._state = new State(impl.getStateMap().getState(impl.getStateDescriptor(cbTileEntity)));
        this.rotate();
        StateUtil.calcCanSeeSky(this);
    }

    public List<AxisAlignedBB> getAxisAlignedBBs() {
        ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
        for (Map.Entry<String, StatePart> entry : this._state.getStateParts().entrySet()) {
            Vec3d min = entry.getValue().getVertexMin();
            Vec3d max = entry.getValue().getVertexMax();
            list.add(new AxisAlignedBB(min.field_72450_a, min.field_72448_b, min.field_72449_c, max.field_72450_a, max.field_72448_b, max.field_72449_c));
        }
        return list;
    }

    public AxisAlignedBB getAxisAlignedBB() {
        double minX = 0.0;
        double minY = 0.0;
        double minZ = 0.0;
        double maxX = 0.0;
        double maxY = 0.0;
        double maxZ = 0.0;
        List<AxisAlignedBB> aabbs = this.getAxisAlignedBBs();
        for (int i = 0; i < aabbs.size(); ++i) {
            AxisAlignedBB aabb = aabbs.get(i);
            if (i == 0) {
                minX = aabb.field_72340_a;
                minY = aabb.field_72338_b;
                minZ = aabb.field_72339_c;
                maxX = aabb.field_72336_d;
                maxY = aabb.field_72337_e;
                maxZ = aabb.field_72334_f;
                continue;
            }
            minX = Math.min(minX, aabb.field_72340_a);
            minY = Math.min(minY, aabb.field_72338_b);
            minZ = Math.min(minZ, aabb.field_72339_c);
            maxX = Math.max(maxX, aabb.field_72336_d);
            maxY = Math.max(maxY, aabb.field_72337_e);
            maxZ = Math.max(maxZ, aabb.field_72334_f);
        }
        return new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public List<StatePart> getStateParts() {
        ArrayList<StatePart> list = new ArrayList<StatePart>();
        for (Map.Entry<String, StatePart> entry : this._state.getStateParts().entrySet()) {
            list.add(entry.getValue());
        }
        return list;
    }

    protected abstract void rotate();
}

