/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.util.handler;

import com.carpentersblocks.CarpentersBlocksCachedResources;
import com.carpentersblocks.util.ModLogger;
import com.carpentersblocks.util.registry.ConfigRegistry;
import com.carpentersblocks.util.registry.SpriteRegistry;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.imageio.ImageIO;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.Level;

public class DesignHandler {
    public static List<String> listChisel = new ArrayList<String>();
    public static List<String> listBed = new ArrayList<String>();
    public static List<String> listFlowerPot = new ArrayList<String>();
    public static List<String> listTile = new ArrayList<String>();
    private static final String PATH_BASE = "assets/carpentersblocks/textures/blocks/";
    private static final String PATH_EXEMPT = "template/";
    private static final String PATH_CHISEL = "blocks/designs/chisel/";
    private static final String PATH_BED = "blocks/designs/bed/";
    private static final String PATH_FLOWER_POT = "blocks/designs/flowerpot/";
    private static final String PATH_TILE = "blocks/designs/tile/";

    private static boolean isPathValid(String path) {
        return path.contains(PATH_BASE) && path.endsWith(".png") && !path.contains(PATH_EXEMPT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void preInit(FMLPreInitializationEvent event) {
        File filePath = new File(event.getSourceFile().getAbsolutePath());
        if (filePath.isDirectory()) {
            for (File file : FileUtils.listFiles((File)filePath, (String[])new String[]{"png"}, (boolean)true)) {
                DesignHandler.processPath(file.getAbsolutePath().replace("\\", "/"));
            }
        } else {
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(event.getSourceFile());
                Enumeration<JarEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    DesignHandler.processPath(((ZipEntry)enumeration.nextElement()).getName());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        ModLogger.log(Level.INFO, String.format("Designs found: Bed(%s), Chisel(%s), FlowerPot(%s), Tile(%s)", listBed.size(), listChisel.size(), listFlowerPot.size(), listTile.size()), new Object[0]);
    }

    private static void processPath(String path) {
        if (DesignHandler.isPathValid(path)) {
            String name = path.substring(path.lastIndexOf(47) + 1, path.lastIndexOf(46));
            if (path.contains(PATH_CHISEL)) {
                listChisel.add(name);
            } else if (path.contains(PATH_BED)) {
                listBed.add(name);
            } else if (path.contains(PATH_FLOWER_POT)) {
                listFlowerPot.add(name);
            } else if (path.contains(PATH_TILE)) {
                listTile.add(name);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void addResources(IResourceManager resourceManager) {
        for (String iconName : listBed) {
            ArrayList<BufferedImage> tempList = DesignHandler.getBedIcons(resourceManager, iconName);
            for (BufferedImage image : tempList) {
                CarpentersBlocksCachedResources.INSTANCE.addResource("/textures/blocks/designs/bed/cache/" + iconName + "_" + tempList.indexOf(image), image);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerSprites(TextureMap textureMap) {
        if (ConfigRegistry.enableBed) {
            for (String spriteName : listBed) {
                TextureAtlasSprite[] sprites = new TextureAtlasSprite[8];
                for (int count = 0; count < 8; ++count) {
                    sprites[count] = textureMap.func_174942_a(new ResourceLocation(CarpentersBlocksCachedResources.INSTANCE.getModId(), "blocks/designs/bed/cache/" + spriteName + "_" + count));
                }
                SpriteRegistry.sprite_design_bed.add(sprites);
            }
        }
        if (ConfigRegistry.enableChiselDesigns) {
            for (String spriteName : listChisel) {
                SpriteRegistry.sprite_design_chisel.add(textureMap.func_174942_a(new ResourceLocation("carpentersblocks", PATH_CHISEL + spriteName)));
            }
        }
        if (ConfigRegistry.enableFlowerPot) {
            for (String spriteName : listFlowerPot) {
                SpriteRegistry.sprite_design_flower_pot.add(textureMap.func_174942_a(new ResourceLocation("carpentersblocks:blocks/designs/flowerpot/" + spriteName)));
            }
        }
        if (ConfigRegistry.enableTile) {
            for (String spriteName : listTile) {
                SpriteRegistry.sprite_design_tile.add(textureMap.func_174942_a(new ResourceLocation("carpentersblocks:blocks/designs/tile/" + spriteName)));
            }
        }
    }

    public static List<String> getListForType(DesignType type) {
        return type.equals((Object)DesignType.CHISEL) ? new ArrayList<String>(listChisel) : (type.equals((Object)DesignType.BED) ? new ArrayList<String>(listBed) : (type.equals((Object)DesignType.FLOWERPOT) ? new ArrayList<String>(listFlowerPot) : (type.equals((Object)DesignType.TILE) ? new ArrayList<String>(listTile) : null)));
    }

    public static String getNext(DesignType type, String iconName) {
        List<String> tempList = DesignHandler.getListForType(type);
        if (tempList.isEmpty()) {
            return iconName;
        }
        int idx = tempList.indexOf(iconName) + 1;
        return tempList.get(idx >= tempList.size() ? 0 : idx);
    }

    public static String getPrev(DesignType type, String iconName) {
        List<String> tempList = DesignHandler.getListForType(type);
        if (tempList.isEmpty()) {
            return iconName;
        }
        int idx = iconName.equals("") ? tempList.size() - 1 : tempList.indexOf(iconName) - 1;
        return tempList.get(idx < 0 ? tempList.size() - 1 : idx);
    }

    @SideOnly(value=Side.CLIENT)
    public static ArrayList<BufferedImage> getBedIcons(IResourceManager resourceManager, String atlas) {
        ArrayList<BufferedImage> imageList = new ArrayList<BufferedImage>();
        try {
            ResourceLocation resourceLocation = new ResourceLocation("carpentersblocks:textures/blocks/designs/bed/" + atlas + ".png");
            BufferedImage image = ImageIO.read(resourceManager.func_110536_a(resourceLocation).func_110527_b());
            int size = image.getWidth() / 3;
            int rows = image.getHeight() / size;
            int cols = image.getWidth() / size;
            int count = -1;
            for (int x = 0; x < rows; ++x) {
                block10: for (int y = 0; y < cols; ++y) {
                    switch (++count) {
                        case 0: 
                        case 2: 
                        case 9: 
                        case 11: {
                            continue block10;
                        }
                        default: {
                            BufferedImage bufferedImage = new BufferedImage(size, size, image.getType());
                            Graphics2D gr = bufferedImage.createGraphics();
                            switch (count) {
                                case 3: 
                                case 6: {
                                    gr.rotate(Math.toRadians(270.0), size / 2, size / 2);
                                    break;
                                }
                                case 5: 
                                case 8: {
                                    gr.rotate(Math.toRadians(90.0), size / 2, size / 2);
                                }
                            }
                            gr.drawImage(image, 0, 0, size, size, size * y, size * x, size * y + size, size * x + size, null);
                            gr.dispose();
                            imageList.add(bufferedImage);
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return imageList;
    }

    public static enum DesignType {
        CHISEL,
        BED,
        FLOWERPOT,
        TILE;

    }
}

