/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.util.attribute;

import com.carpentersblocks.util.attribute.EnumAttributeLocation;
import com.carpentersblocks.util.attribute.EnumAttributeType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class AbstractAttribute<K> {
    public static final String TAG_ATTR_LOCATION = "cbAttrLocation";
    public static final String TAG_ATTR_TYPE = "cbAttrType";
    public static final String TAG_ATTR_IDENT = "cbAttrModel";
    public static final String IDENT_ATTR_ITEMSTACK = "ItemStack";
    public static final String IDENT_ATTR_STRING = "String";
    protected EnumAttributeType _type;
    protected EnumAttributeLocation _location;
    protected K _model;

    public AbstractAttribute(EnumAttributeLocation location, EnumAttributeType type, K model) {
        this._location = location;
        this._type = type;
        this._model = model;
    }

    public void setModel(K model) {
        this._model = model;
    }

    public K getModel() {
        return this._model;
    }

    public EnumAttributeType getType() {
        return this._type;
    }

    public EnumAttributeLocation getLocation() {
        return this._location;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a(TAG_ATTR_LOCATION, this._location.ordinal());
        nbt.func_74768_a(TAG_ATTR_TYPE, this._type.ordinal());
        nbt.func_74778_a(TAG_ATTR_IDENT, this.getModelIdentifier());
        this.writeModelToNBT(nbt);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this._location = EnumAttributeLocation.valueOf(nbt.func_74762_e(TAG_ATTR_LOCATION) & 0xFF);
        this._type = EnumAttributeType.valueOf(nbt.func_74762_e(TAG_ATTR_TYPE) & 0xFF);
        this.readModelFromNBT(nbt);
    }

    public abstract String getModelIdentifier();

    public abstract void writeModelToNBT(NBTTagCompound var1);

    public abstract void readModelFromNBT(NBTTagCompound var1);

    public static Key generateKey(EnumAttributeLocation location, EnumAttributeType type) {
        return new Key(location, type);
    }

    public Key getKey() {
        return new Key(this._location, this._type);
    }

    public boolean isDroppable() {
        return this._model instanceof ItemStack;
    }

    public abstract AbstractAttribute copy();

    public static class Key {
        private EnumAttributeLocation _location;
        private EnumAttributeType _type;

        public Key(int hashCode) {
            this(EnumAttributeLocation.valueOf(hashCode >>> 16), EnumAttributeType.valueOf(hashCode & 0xFFFF));
        }

        public Key(EnumAttributeLocation _location, EnumAttributeType _type) {
            this._location = _location;
            this._type = _type;
        }

        public EnumAttributeLocation getLocation() {
            return this._location;
        }

        public EnumAttributeType getType() {
            return this._type;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            Key attr = (Key)obj;
            return this._type == attr._type && this._location == attr._location;
        }

        public int hashCode() {
            return this._location.ordinal() << 16 | this._type.ordinal();
        }
    }
}

