/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.util.blockiterators;

import com.enderio.core.common.util.blockiterators.CubicBlockIterator;
import javax.annotation.Nonnull;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class PlanarBlockIterator
extends CubicBlockIterator {
    @Nonnull
    private Orientation orientation;

    public PlanarBlockIterator(@Nonnull BlockPos base, @Nonnull Orientation orientation, int radius) {
        super(base, radius);
        this.orientation = orientation;
        switch (orientation) {
            case EAST_WEST: {
                this.curZ = base.func_177952_p();
            }
            case NORTH_SOUTH: {
                this.curX = base.func_177958_n();
            }
            case HORIZONTAL: {
                this.curY = base.func_177956_o();
            }
        }
    }

    @Override
    @Nonnull
    public BlockPos next() {
        BlockPos coord = new BlockPos(this.curX, this.curY, this.curZ);
        switch (this.orientation) {
            case EAST_WEST: {
                this.curY = this.curY == this.maxY ? this.minY : this.curY + 1;
                this.curX = this.curY == this.minY ? this.curX + 1 : this.curX;
            }
            case NORTH_SOUTH: {
                this.curY = this.curY == this.maxY ? this.minY : this.curY + 1;
                this.curZ = this.curY == this.minY ? this.curZ + 1 : this.curZ;
            }
            case HORIZONTAL: {
                this.curX = this.curX == this.maxX ? this.minX : this.curX + 1;
                this.curZ = this.curX == this.minX ? this.curZ + 1 : this.curZ;
            }
        }
        return coord;
    }

    @Override
    public boolean hasNext() {
        return this.curX <= this.maxX && this.curY <= this.maxY && this.curZ <= this.maxZ;
    }

    public static enum Orientation {
        EAST_WEST,
        NORTH_SOUTH,
        HORIZONTAL;


        @Nonnull
        public static Orientation perpendicular(@Nonnull EnumFacing dir) {
            switch (dir) {
                case NORTH: 
                case SOUTH: {
                    return EAST_WEST;
                }
                case EAST: 
                case WEST: {
                    return NORTH_SOUTH;
                }
            }
            return HORIZONTAL;
        }
    }
}

