/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.util;

import com.enderio.core.EnderCore;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import com.enderio.core.common.vecmath.Vector3d;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class EntityUtil {
    private static final Random rand = new Random();

    public static void setEntityVelocity(Entity entity, double velX, double velY, double velZ) {
        entity.field_70159_w = velX;
        entity.field_70181_x = velY;
        entity.field_70179_y = velZ;
    }

    @Nonnull
    public static EntityFireworkRocket getRandomFirework(@Nonnull World world) {
        return EntityUtil.getRandomFirework(world, new BlockPos(0, 0, 0));
    }

    @Nonnull
    public static EntityFireworkRocket getRandomFirework(@Nonnull World world, @Nonnull BlockPos pos) {
        ItemStack firework = new ItemStack(Items.field_151152_bP);
        firework.func_77982_d(new NBTTagCompound());
        NBTTagCompound expl = new NBTTagCompound();
        expl.func_74757_a("Flicker", true);
        expl.func_74757_a("Trail", true);
        int[] colors = new int[rand.nextInt(8) + 1];
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = ItemDye.field_150922_c[rand.nextInt(16)];
        }
        expl.func_74783_a("Colors", colors);
        byte type = (byte)(rand.nextInt(3) + 1);
        type = type == 3 ? (byte)4 : (byte)type;
        expl.func_74774_a("Type", type);
        NBTTagList explosions = new NBTTagList();
        explosions.func_74742_a((NBTBase)expl);
        NBTTagCompound fireworkTag = new NBTTagCompound();
        fireworkTag.func_74782_a("Explosions", (NBTBase)explosions);
        fireworkTag.func_74774_a("Flight", (byte)1);
        firework.func_77983_a("Fireworks", (NBTBase)fireworkTag);
        EntityFireworkRocket e = new EntityFireworkRocket(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, firework);
        return e;
    }

    public static void spawnFirework(@Nonnull BlockPos block, int dimID) {
        EntityUtil.spawnFirework(block, dimID, 0);
    }

    public static void spawnFirework(@Nonnull BlockPos pos, int dimID, int range) {
        WorldServer world = DimensionManager.getWorld((int)dimID);
        BlockPos spawnPos = pos;
        if (range > 0) {
            spawnPos = new BlockPos(EntityUtil.moveRandomly(spawnPos.func_177958_n(), range), (double)spawnPos.func_177956_o(), EntityUtil.moveRandomly(spawnPos.func_177952_p(), range));
            IBlockState bs = world.func_180495_p(spawnPos);
            int tries = -1;
            while (!world.func_175623_d(new BlockPos((Vec3i)spawnPos)) && !bs.func_177230_c().func_176200_f((IBlockAccess)world, spawnPos)) {
                if (++tries <= 100) continue;
                return;
            }
        }
        world.func_72838_d((Entity)EntityUtil.getRandomFirework((World)world, spawnPos));
    }

    private static double moveRandomly(double base, double range) {
        return base + 0.5 + rand.nextDouble() * range - range / 2.0;
    }

    @Nonnull
    public static String getDisplayNameForEntity(@Nonnull String mobName) {
        return EnderCore.lang.localizeExact("entity." + mobName + ".name");
    }

    @Nonnull
    public static NNList<ResourceLocation> getAllRegisteredMobNames() {
        NNList<ResourceLocation> result = new NNList<ResourceLocation>();
        for (ResourceLocation entityName : EntityList.func_180124_b()) {
            Class clazz = EntityList.getClass((ResourceLocation)NullHelper.notnullF(entityName, "EntityList.getEntityNameList()"));
            if (clazz == null || !EntityLiving.class.isAssignableFrom(clazz)) continue;
            result.add(entityName);
        }
        return result;
    }

    public static boolean isRegisteredMob(ResourceLocation entityName) {
        if (entityName != null) {
            Class clazz = EntityList.getClass((ResourceLocation)entityName);
            return clazz != null && EntityLiving.class.isAssignableFrom(clazz);
        }
        return false;
    }

    private EntityUtil() {
    }

    public static Vector3d getEntityPosition(@Nonnull Entity ent) {
        return new Vector3d(ent.field_70165_t, ent.field_70163_u, ent.field_70161_v);
    }

    public static List<AxisAlignedBB> getCollidingBlockGeometry(@Nonnull World world, @Nonnull Entity entity) {
        AxisAlignedBB entityBounds = entity.func_174813_aQ();
        ArrayList<AxisAlignedBB> collidingBoundingBoxes = new ArrayList<AxisAlignedBB>();
        int minX = MathHelper.func_76128_c((double)entityBounds.field_72340_a);
        int minY = MathHelper.func_76128_c((double)entityBounds.field_72338_b);
        int minZ = MathHelper.func_76128_c((double)entityBounds.field_72339_c);
        int maxX = MathHelper.func_76128_c((double)(entityBounds.field_72336_d + 1.0));
        int maxY = MathHelper.func_76128_c((double)(entityBounds.field_72337_e + 1.0));
        int maxZ = MathHelper.func_76128_c((double)(entityBounds.field_72334_f + 1.0));
        for (int x = minX; x < maxX; ++x) {
            for (int z = minZ; z < maxZ; ++z) {
                for (int y = minY; y < maxY; ++y) {
                    BlockPos pos = new BlockPos(x, y, z);
                    world.func_180495_p(pos).func_185908_a(world, pos, entityBounds, collidingBoundingBoxes, entity, false);
                }
            }
        }
        return collidingBoundingBoxes;
    }

    public static void spawnItemInWorldWithRandomMotion(@Nonnull World world, @Nonnull ItemStack item, int x, int y, int z) {
        if (!item.func_190926_b()) {
            EntityUtil.spawnItemInWorldWithRandomMotion(world, item, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
        }
    }

    public static void spawnItemInWorldWithRandomMotion(@Nonnull World world, @Nonnull ItemStack item, double x, double y, double z) {
        if (!item.func_190926_b()) {
            EntityUtil.spawnItemInWorldWithRandomMotion(new EntityItem(world, x, y, z, item));
        }
    }

    public static void spawnItemInWorldWithRandomMotion(@Nonnull EntityItem entity) {
        entity.func_174869_p();
        float f = entity.field_70170_p.field_73012_v.nextFloat() * 0.1f - 0.05f;
        float f1 = entity.field_70170_p.field_73012_v.nextFloat() * 0.1f - 0.05f;
        float f2 = entity.field_70170_p.field_73012_v.nextFloat() * 0.1f - 0.05f;
        entity.field_70159_w += (double)f;
        entity.field_70181_x += (double)f1;
        entity.field_70179_y += (double)f2;
        entity.field_70170_p.func_72838_d((Entity)entity);
    }
}

