/*
 * Decompiled with CFR 0.152.
 */
package worldcontrolteam.worldcontrol.client.model.util;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

@SideOnly(value=Side.CLIENT)
public class TextureArray {
    protected TextureAtlasSprite particle;
    protected TextureAtlasSprite northTexture;
    protected TextureAtlasSprite southTexture;
    protected TextureAtlasSprite upTexture;
    protected TextureAtlasSprite downTexture;
    protected TextureAtlasSprite eastTexture;
    protected TextureAtlasSprite westTexture;

    public TextureArray(TextureAtlasSprite particle, TextureAtlasSprite northTexture, TextureAtlasSprite southTexture, TextureAtlasSprite upTexture, TextureAtlasSprite downTexture, TextureAtlasSprite eastTexture, TextureAtlasSprite westTexture) {
        this.particle = particle;
        this.northTexture = northTexture;
        this.southTexture = southTexture;
        this.upTexture = upTexture;
        this.downTexture = downTexture;
        this.eastTexture = eastTexture;
        this.westTexture = westTexture;
    }

    public TextureArray(TextureAtlasSprite texture) {
        this(texture, texture, texture, texture, texture, texture, texture);
    }

    public TextureArray() {
        this(Minecraft.func_71410_x().func_147117_R().func_174944_f());
    }

    public TextureAtlasSprite getParticleTexture() {
        return this.particle != null ? this.particle : Minecraft.func_71410_x().func_147117_R().func_174944_f();
    }

    public TextureArray setParticleTexture(TextureAtlasSprite particle) {
        this.particle = particle;
        return this;
    }

    public TextureAtlasSprite[] getTextureArray() {
        return new TextureAtlasSprite[]{this.getNorthTexture(), this.getEastTexture(), this.getSouthTexture(), this.getWestTexture(), this.getUpTexture(), this.getDownTexture()};
    }

    public TextureAtlasSprite getNorthTexture() {
        return this.northTexture;
    }

    public TextureArray setNorthTexture(TextureAtlasSprite northTexture) {
        this.northTexture = northTexture;
        return this;
    }

    public TextureAtlasSprite getSouthTexture() {
        return this.southTexture;
    }

    public TextureArray setSouthTexture(TextureAtlasSprite southTexture) {
        this.southTexture = southTexture;
        return this;
    }

    public TextureAtlasSprite getUpTexture() {
        return this.upTexture;
    }

    public TextureArray setUpTexture(TextureAtlasSprite upTexture) {
        this.upTexture = upTexture;
        return this;
    }

    public TextureAtlasSprite getDownTexture() {
        return this.downTexture;
    }

    public TextureArray setDownTexture(TextureAtlasSprite downTexture) {
        this.downTexture = downTexture;
        return this;
    }

    public TextureAtlasSprite getEastTexture() {
        return this.eastTexture;
    }

    public TextureArray setEastTexture(TextureAtlasSprite eastTexture) {
        this.eastTexture = eastTexture;
        return this;
    }

    public TextureAtlasSprite getWestTexture() {
        return this.westTexture;
    }

    public TextureArray setWestTexture(TextureAtlasSprite westTexture) {
        this.westTexture = westTexture;
        return this;
    }

    public TextureArray setTexture(EnumFacing f, TextureAtlasSprite tex) {
        switch (f) {
            case UP: {
                return this.setUpTexture(tex);
            }
            case DOWN: {
                return this.setDownTexture(tex);
            }
            case EAST: {
                return this.setEastTexture(tex);
            }
            case WEST: {
                return this.setWestTexture(tex);
            }
            case NORTH: {
                return this.setNorthTexture(tex);
            }
        }
        return this.setSouthTexture(tex);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("particle", (Object)this.particle).append("northTexture", (Object)this.northTexture).append("southTexture", (Object)this.southTexture).append("upTexture", (Object)this.upTexture).append("downTexture", (Object)this.downTexture).append("eastTexture", (Object)this.eastTexture).append("westTexture", (Object)this.westTexture).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextureArray that = (TextureArray)o;
        return new EqualsBuilder().append((Object)this.getParticleTexture(), (Object)that.getParticleTexture()).append((Object)this.getNorthTexture(), (Object)that.getNorthTexture()).append((Object)this.getSouthTexture(), (Object)that.getSouthTexture()).append((Object)this.getUpTexture(), (Object)that.getUpTexture()).append((Object)this.getDownTexture(), (Object)that.getDownTexture()).append((Object)this.getEastTexture(), (Object)that.getEastTexture()).append((Object)this.getWestTexture(), (Object)that.getWestTexture()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.getParticleTexture()).append((Object)this.getNorthTexture()).append((Object)this.getSouthTexture()).append((Object)this.getUpTexture()).append((Object)this.getDownTexture()).append((Object)this.getEastTexture()).append((Object)this.getWestTexture()).toHashCode();
    }
}

