/*
 * Decompiled with CFR 0.152.
 */
package worldcontrolteam.worldcontrol.client.model.infopanel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.property.IExtendedBlockState;
import org.apache.commons.lang3.tuple.ImmutablePair;
import worldcontrolteam.worldcontrol.blocks.BlockBasicRotate;
import worldcontrolteam.worldcontrol.blocks.BlockInfoPanel;
import worldcontrolteam.worldcontrol.client.model.base.SimpleBlockModel;
import worldcontrolteam.worldcontrol.client.model.util.TextureArray;

public class ModelInfoPanel
extends SimpleBlockModel {
    private static ArrayList<ResourceLocation> textures_ = new ArrayList();
    private final ResourceLocation side;
    private final ResourceLocation back;

    public ModelInfoPanel(ResourceLocation side, ResourceLocation back) {
        super(textures_);
        this.textures.add(side);
        this.textures.add(back);
        this.side = side;
        this.back = back;
    }

    public IBakedModel bake(IModelState iModelState, VertexFormat vertexFormat, Function<ResourceLocation, TextureAtlasSprite> function) {
        return new Baked(vertexFormat, this, function, this.side, this.back);
    }

    static {
        for (int i = 0; i < 15; ++i) {
            for (int j = 0; j < 16; ++j) {
                textures_.add(new ResourceLocation("worldcontrol:blocks/infopanel/on/" + String.valueOf(i) + "/" + String.valueOf(j)));
                textures_.add(new ResourceLocation("worldcontrol:blocks/infopanel/off/" + String.valueOf(i) + "/" + String.valueOf(j)));
            }
        }
    }

    public static class Baked
    extends SimpleBlockModel.Baked {
        private Map<ImmutablePair<BlockInfoPanel.InfoPanelState, Integer>, TextureArray> cache = new HashMap<ImmutablePair<BlockInfoPanel.InfoPanelState, Integer>, TextureArray>();
        private final ResourceLocation side;
        private final ResourceLocation back;

        public Baked(VertexFormat fmt, SimpleBlockModel parent, Function<ResourceLocation, TextureAtlasSprite> func, ResourceLocation side, ResourceLocation back) {
            super(fmt, parent, func);
            this.side = side;
            this.back = back;
        }

        public TextureAtlasSprite getConnectedFace(BlockInfoPanel.InfoPanelState state) {
            int color = state.color;
            int bitfield = 0;
            bitfield += state.left ? 0 : 1;
            bitfield += state.right ? 0 : 2;
            bitfield += state.up ? 0 : 4;
            return (TextureAtlasSprite)this.sprites.get(new ResourceLocation("worldcontrol:blocks/infopanel/" + (state.power ? "on" : "off") + "/" + String.valueOf(color) + "/" + String.valueOf(bitfield += state.down ? 0 : 8)));
        }

        @Override
        public TextureArray getTextureArray(@Nullable IBlockState s) {
            ImmutablePair key;
            EnumFacing f;
            BlockInfoPanel.InfoPanelState state = new BlockInfoPanel.InfoPanelState();
            Object object = f = s != null ? (Comparable)s.func_177228_b().get((Object)BlockBasicRotate.FACING) : EnumFacing.NORTH;
            if (s instanceof IExtendedBlockState) {
                state = (BlockInfoPanel.InfoPanelState)((Optional)((IExtendedBlockState)s).getUnlistedProperties().get(BlockInfoPanel.STATE)).get();
            }
            if (this.cache.containsKey(key = new ImmutablePair((Object)state, (Object)f.func_176745_a()))) {
                return this.cache.get(key);
            }
            TextureAtlasSprite sideSprite = (TextureAtlasSprite)this.sprites.get(this.side);
            TextureArray textureArray = new TextureArray().setDownTexture(sideSprite).setParticleTexture(sideSprite).setEastTexture(sideSprite).setNorthTexture(sideSprite).setUpTexture(sideSprite).setWestTexture(sideSprite).setSouthTexture(sideSprite);
            textureArray.setTexture(f, this.getConnectedFace(state));
            textureArray.setTexture(f.func_176734_d(), (TextureAtlasSprite)this.sprites.get(this.back));
            this.cache.put((ImmutablePair<BlockInfoPanel.InfoPanelState, Integer>)key, textureArray);
            return textureArray;
        }
    }
}

