/*
 * Decompiled with CFR 0.152.
 */
package worldcontrolteam.worldcontrol.blocks;

import com.google.common.collect.ImmutableMap;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import org.apache.commons.lang3.tuple.ImmutablePair;
import worldcontrolteam.worldcontrol.blocks.BlockBasicRotate;
import worldcontrolteam.worldcontrol.client.ClientUtil;
import worldcontrolteam.worldcontrol.screen.IScreenContainer;
import worldcontrolteam.worldcontrol.tileentity.TileEntityInfoPanel;
import worldcontrolteam.worldcontrol.utils.WCUtility;

public class BlockInfoPanel
extends BlockBasicRotate
implements IScreenContainer {
    private static ImmutableMap<EnumFacing, ImmutablePair<EnumFacing, EnumFacing>> facings;
    public static final IUnlistedProperty<InfoPanelState> STATE;

    public BlockInfoPanel(Material material, String name, boolean advanced) {
        super(material, name);
        this.defaultCreativeTab();
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        super.func_180633_a(world, pos, state, entity, stack);
        WCUtility.getTileEntity((IBlockAccess)world, pos, TileEntityInfoPanel.class).ifPresent(TileEntityInfoPanel::init);
    }

    public boolean isConnectedTo(IBlockAccess world, BlockPos p, BlockPos me) {
        Block block = world.func_180495_p(p).func_177230_c();
        return block instanceof IScreenContainer && WCUtility.compareBPos(((IScreenContainer)block).getOrigin(world, p), me);
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state instanceof IExtendedBlockState) {
            TileEntity te_origin;
            IExtendedBlockState estate = (IExtendedBlockState)state;
            InfoPanelState istate = new InfoPanelState();
            istate.color = 3;
            istate.power = false;
            BlockPos origin = pos;
            if (origin != null && (te_origin = world.func_175625_s(origin)) instanceof TileEntityInfoPanel) {
                istate.color = ((TileEntityInfoPanel)te_origin).color;
                istate.power = ((TileEntityInfoPanel)te_origin).power;
            }
            EnumFacing f = this.getFacing(world, pos);
            istate.down = this.isConnectedTo(world, pos.func_177972_a((EnumFacing)((ImmutablePair)facings.get((Object)f)).getKey()), pos);
            istate.up = this.isConnectedTo(world, pos.func_177972_a(((EnumFacing)((ImmutablePair)facings.get((Object)f)).getKey()).func_176734_d()), pos);
            istate.left = this.isConnectedTo(world, pos.func_177972_a((EnumFacing)((ImmutablePair)facings.get((Object)f)).getValue()), pos);
            istate.right = this.isConnectedTo(world, pos.func_177972_a(((EnumFacing)((ImmutablePair)facings.get((Object)f)).getValue()).func_176734_d()), pos);
            estate = estate.withProperty(STATE, (Object)istate);
            return estate;
        }
        return state;
    }

    @Override
    public void registerModels(ModelRegistryEvent event) {
        ClientUtil.registerToNormalWithoutMapper(this);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{FACING}).add(new IUnlistedProperty[]{STATE}).build();
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        WCUtility.getTileEntity((IBlockAccess)world, pos, TileEntityInfoPanel.class).ifPresent(te -> te.updateAllProviders(true));
        super.func_180663_b(world, pos, state);
    }

    @Override
    public TileEntity createTile(World world, int meta) {
        TileEntityInfoPanel tileEntityInfoPanel = new TileEntityInfoPanel();
        tileEntityInfoPanel.func_145834_a(world);
        return tileEntityInfoPanel;
    }

    @Override
    public boolean hasGUI() {
        return true;
    }

    @Override
    public int guiID() {
        return 6;
    }

    @Override
    public EnumFacing getFacing(IBlockAccess worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos).func_177230_c() == this ? (EnumFacing)worldIn.func_180495_p(pos).func_177228_b().get((Object)FACING) : EnumFacing.DOWN;
    }

    @Override
    public BlockPos getOrigin(IBlockAccess worldIn, BlockPos pos) {
        return pos;
    }

    @Override
    public boolean isValid(World worldIn, BlockPos pos) {
        return true;
    }

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        builder.put((Object)EnumFacing.UP, (Object)new ImmutablePair((Object)EnumFacing.SOUTH, (Object)EnumFacing.WEST));
        builder.put((Object)EnumFacing.DOWN, (Object)new ImmutablePair((Object)EnumFacing.SOUTH, (Object)EnumFacing.EAST));
        builder.put((Object)EnumFacing.NORTH, (Object)new ImmutablePair((Object)EnumFacing.DOWN, (Object)EnumFacing.EAST));
        builder.put((Object)EnumFacing.SOUTH, (Object)new ImmutablePair((Object)EnumFacing.DOWN, (Object)EnumFacing.WEST));
        builder.put((Object)EnumFacing.EAST, (Object)new ImmutablePair((Object)EnumFacing.DOWN, (Object)EnumFacing.SOUTH));
        builder.put((Object)EnumFacing.WEST, (Object)new ImmutablePair((Object)EnumFacing.DOWN, (Object)EnumFacing.NORTH));
        facings = builder.build();
        STATE = new IUnlistedProperty<InfoPanelState>(){

            public String getName() {
                return "state";
            }

            public boolean isValid(InfoPanelState infoPanelState) {
                return true;
            }

            public Class<InfoPanelState> getType() {
                return InfoPanelState.class;
            }

            public String valueToString(InfoPanelState infoPanelState) {
                return "asdf";
            }
        };
    }

    public static class InfoPanelState {
        public boolean up;
        public boolean down;
        public boolean left;
        public boolean right;
        public boolean power;
        public int color;

        public String toString() {
            return "asdf";
        }

        public int hashCode() {
            return (this.up ? 1 : 0) + (this.down ? 2 : 0) + (this.left ? 4 : 0) + (this.right ? 8 : 0) + (this.power ? 16 : 0) + this.color << 5;
        }

        public boolean equals(Object obj) {
            if (obj instanceof InfoPanelState) {
                InfoPanelState that = (InfoPanelState)obj;
                return that.power == this.power && that.up == this.up && this.down == that.down && this.left == that.left && this.right == that.right && this.color == that.color;
            }
            return false;
        }
    }
}

