/*
 * Decompiled with CFR 0.152.
 */
package dongle12.miscrails.util;

import dongle12.miscrails.blocks.LauncherBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class RailUtil {
    public static boolean FoundRail(World world, BlockPos pos) {
        Block found = world.func_180495_p(pos).func_177230_c();
        return found instanceof BlockRailBase;
    }

    public static boolean IsBlock(World world, BlockPos pos) {
        Block found = world.func_180495_p(pos).func_177230_c();
        return found instanceof Block;
    }

    public static boolean IsLauncherBlock(World world, BlockPos pos) {
        Block found = world.func_180495_p(pos).func_177230_c();
        return found instanceof LauncherBlock;
    }

    public static BlockRailBase.EnumRailDirection RailDirection(World world, EntityMinecart cart, BlockPos pos) {
        BlockRailBase.EnumRailDirection dir = null;
        IBlockState curState = world.func_180495_p(pos);
        if (curState.func_177230_c() instanceof BlockRailBase) {
            dir = ((BlockRailBase)curState.func_177230_c()).getRailDirection((IBlockAccess)world, pos, curState, cart);
            return dir;
        }
        return null;
    }

    public static float setRailSpeed(BlockRailBase superClass, World world, EntityMinecart cart, BlockPos pos, float speedMultiplier) {
        float retSpeed = 0.4f;
        for (EnumFacing side : EnumFacing.field_176754_o) {
            BlockPos nextPos = pos.func_177972_a(side);
            boolean foundRail = RailUtil.FoundRail(world, nextPos);
            if (!foundRail) {
                if (RailUtil.FoundRail(world, nextPos.func_177977_b())) {
                    foundRail = true;
                    nextPos = nextPos.func_177984_a();
                } else if (RailUtil.FoundRail(world, nextPos.func_177977_b())) {
                    foundRail = true;
                    nextPos = nextPos.func_177977_b();
                }
            }
            if (!foundRail) continue;
            BlockRailBase.EnumRailDirection dir = RailUtil.RailDirection(world, cart, pos);
            BlockRailBase.EnumRailDirection dirNext = RailUtil.RailDirection(world, cart, nextPos);
            retSpeed = dir != null && dir.func_177018_c() || dirNext != null && dirNext.func_177018_c() ? 0.4f : superClass.getRailMaxSpeed(world, cart, pos) * speedMultiplier;
        }
        return retSpeed;
    }
}

