/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.load.json.serial;

import alexiil.mc.mod.load.json.ConfigManager;
import alexiil.mc.mod.load.json.JsonInsn;
import alexiil.mc.mod.load.json.serial.IThrowingDeserialiser;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.api.InvalidExpressionException;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.util.JsonUtils;

public enum InstructionDeserialiser implements IThrowingDeserialiser<JsonInsn>
{
    INSTANCE;

    private static final Map<String, TypeDeserialiser> types;
    private static String validTypes;

    private static void putType(String type, TypeDeserialiser des) {
        types.put(type, des);
        validTypes = Arrays.toString(types.keySet().toArray());
    }

    @Override
    public JsonInsn deserialize0(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws InvalidExpressionException {
        if (json.isJsonObject()) {
            JsonObject obj = json.getAsJsonObject();
            String type = JsonUtils.func_151200_h((JsonObject)obj, (String)"parent");
            TypeDeserialiser des = types.get(type);
            if (des != null) {
                JsonInsn insn = des.deserialize(obj);
                insn.setSource((JsonElement)obj);
                return insn;
            }
            throw new JsonSyntaxException("Unknown instruction type" + type + ", should be one of " + validTypes);
        }
        if (json.isJsonPrimitive()) {
            JsonPrimitive prim = json.getAsJsonPrimitive();
            if (prim.isString()) {
                return ConfigManager.getAsInsn(prim.getAsString());
            }
            throw new JsonSyntaxException("Expected an object or a string, found " + prim);
        }
        throw new JsonSyntaxException("Expected an object or a string, found " + json);
    }

    private static String getOptionalString(JsonObject obj, String member, String fallback) {
        if (obj.has(member)) {
            return JsonUtils.func_151200_h((JsonObject)obj, (String)member);
        }
        return fallback;
    }

    private static JsonInsn.JsonInsnTranslate deserialiseTranslation(JsonObject obj) {
        String x = JsonUtils.func_151200_h((JsonObject)obj, (String)"x");
        String y = JsonUtils.func_151200_h((JsonObject)obj, (String)"y");
        String z = InstructionDeserialiser.getOptionalString(obj, "z", "0");
        return new JsonInsn.JsonInsnTranslate(x, y, z);
    }

    private static JsonInsn.JsonInsnScale deserialiseScale(JsonObject obj) {
        String x = JsonUtils.func_151200_h((JsonObject)obj, (String)"x");
        String y = JsonUtils.func_151200_h((JsonObject)obj, (String)"y");
        String z = InstructionDeserialiser.getOptionalString(obj, "z", "0");
        return new JsonInsn.JsonInsnScale(x, y, z);
    }

    private static JsonInsn.JsonInsnRotate deserialiseRotation(JsonObject obj) {
        String a = JsonUtils.func_151200_h((JsonObject)obj, (String)"angle");
        String x = InstructionDeserialiser.getOptionalString(obj, "x", "0");
        String y = InstructionDeserialiser.getOptionalString(obj, "y", "0");
        String z = InstructionDeserialiser.getOptionalString(obj, "z", "0");
        return new JsonInsn.JsonInsnRotate(a, x, y, z);
    }

    private static JsonInsn deserialiseColour0(JsonObject obj) {
        if (obj.has("rgb")) {
            String rgb = JsonUtils.func_151200_h((JsonObject)obj, (String)"argb");
            return InstructionDeserialiser.createFromRgb(rgb);
        }
        if (obj.has("argb")) {
            String argb = JsonUtils.func_151200_h((JsonObject)obj, (String)"argb");
            return new JsonInsn.JsonInsnColourTogether(argb);
        }
        String a = obj.has("a") ? JsonUtils.func_151200_h((JsonObject)obj, (String)"a") : "0xFF";
        String r = JsonUtils.func_151200_h((JsonObject)obj, (String)"r");
        String g = JsonUtils.func_151200_h((JsonObject)obj, (String)"g");
        String b = JsonUtils.func_151200_h((JsonObject)obj, (String)"b");
        return new JsonInsn.JsonInsnColourSplit(a, r, g, b);
    }

    private static JsonInsn.JsonInsnColourTogether createFromRgb(String rgb) {
        return new JsonInsn.JsonInsnColourTogether("0xFF_00_00_00 | (" + rgb + ")");
    }

    public static JsonInsn deserialiseColour(JsonElement elem) {
        if (elem.isJsonPrimitive() && ((JsonPrimitive)elem).isString()) {
            String argb = elem.getAsString();
            JsonInsn.JsonInsnColourTogether insn = InstructionDeserialiser.createFromRgb(argb);
            insn.setSource(elem);
            return insn;
        }
        if (elem.isJsonObject()) {
            JsonInsn insn = InstructionDeserialiser.deserialiseColour0(elem.getAsJsonObject());
            insn.setSource(elem);
            return insn;
        }
        throw new JsonSyntaxException("Expected an object or a string, got " + elem);
    }

    static {
        types = new LinkedHashMap<String, TypeDeserialiser>();
        validTypes = "[]";
        InstructionDeserialiser.putType("builtin/translate", InstructionDeserialiser::deserialiseTranslation);
        InstructionDeserialiser.putType("builtin/scale", InstructionDeserialiser::deserialiseScale);
        InstructionDeserialiser.putType("builtin/rotate", InstructionDeserialiser::deserialiseRotation);
        InstructionDeserialiser.putType("builtin/colour", InstructionDeserialiser::deserialiseColour0);
    }

    @FunctionalInterface
    private static interface TypeDeserialiser {
        public JsonInsn deserialize(JsonObject var1) throws JsonParseException;
    }
}

