/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.data.numbers.world;

import cofh.cofhworld.data.numbers.INumberProvider;
import cofh.cofhworld.util.Utils;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public enum WorldValueEnum {
    WORLD_HEIGHT{

        @Override
        public long getValue(World world, Random rand, INumberProvider.DataHolder data) {
            return world.func_72940_L();
        }
    }
    ,
    SEA_LEVEL{

        @Override
        public long getValue(World world, Random rand, INumberProvider.DataHolder data) {
            return world.func_181545_F();
        }
    }
    ,
    GROUND_LEVEL{

        @Override
        public long getValue(World world, Random rand, INumberProvider.DataHolder data) {
            return world.field_73011_w.func_76557_i();
        }
    }
    ,
    RAIN_HEIGHT{

        @Override
        public long getValue(World world, Random rand, INumberProvider.DataHolder data) {
            return world.func_175725_q(new BlockPos(data.getPos("position"))).func_177956_o();
        }
    }
    ,
    HEIGHT_MAP{

        @Override
        public long getValue(World world, Random rand, INumberProvider.DataHolder data) {
            Vec3i pos = data.getPos("position");
            return world.func_189649_b(pos.func_177958_n(), pos.func_177952_p());
        }
    }
    ,
    HIGHEST_BLOCK{

        @Override
        public long getValue(World world, Random rand, INumberProvider.DataHolder data) {
            Vec3i pos = data.getPos("position");
            return Utils.getTopBlockY(world, pos.func_177958_n(), pos.func_177956_o());
        }
    }
    ,
    SURFACE_BLOCK{

        @Override
        public long getValue(World world, Random rand, INumberProvider.DataHolder data) {
            Vec3i pos = data.getPos("position");
            return Utils.getSurfaceBlockY(world, pos.func_177958_n(), pos.func_177952_p());
        }
    }
    ,
    LOWEST_CHUNK_HORIZON{

        @Override
        public long getValue(World world, Random rand, INumberProvider.DataHolder data) {
            Vec3i pos = data.getPos("position");
            return world.func_82734_g(pos.func_177958_n(), pos.func_177952_p());
        }
    }
    ,
    SPAWN_X{

        @Override
        public long getValue(World world, Random rand, INumberProvider.DataHolder data) {
            return world.func_175694_M().func_177958_n();
        }
    }
    ,
    SPAWN_Y{

        @Override
        public long getValue(World world, Random rand, INumberProvider.DataHolder data) {
            return world.func_175694_M().func_177956_o();
        }
    }
    ,
    SPAWN_Z{

        @Override
        public long getValue(World world, Random rand, INumberProvider.DataHolder data) {
            return world.func_175694_M().func_177952_p();
        }
    }
    ,
    CURRENT_X{

        @Override
        public long getValue(World world, Random rand, INumberProvider.DataHolder data) {
            Vec3i pos = data.getPos("position");
            return pos.func_177958_n();
        }
    }
    ,
    CURRENT_Y{

        @Override
        public long getValue(World world, Random rand, INumberProvider.DataHolder data) {
            Vec3i pos = data.getPos("position");
            return pos.func_177956_o();
        }
    }
    ,
    CURRENT_Z{

        @Override
        public long getValue(World world, Random rand, INumberProvider.DataHolder data) {
            Vec3i pos = data.getPos("position");
            return pos.func_177952_p();
        }
    };


    public abstract long getValue(World var1, Random var2, INumberProvider.DataHolder var3);
}

