/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.common.item;

import growthcraft.core.shared.definition.IObjectVariant;
import growthcraft.core.shared.io.nbt.NBTHelper;
import growthcraft.core.shared.item.IItemTileBlock;
import growthcraft.milk.common.item.ItemBlockCheeseBase;
import growthcraft.milk.shared.cheese.CheeseIO;
import growthcraft.milk.shared.cheese.CheeseUtils;
import growthcraft.milk.shared.definition.ICheeseCurdStackFactory;
import growthcraft.milk.shared.definition.ICheeseType;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBlockHangingCurds<T extends ICheeseType & IObjectVariant>
extends ItemBlockCheeseBase<T>
implements IItemTileBlock {
    public ItemBlockHangingCurds(Block block, T[] typeLookup) {
        super(block, typeLookup);
    }

    private NBTTagCompound getTileTagCompoundABS(ItemStack stack) {
        NBTTagCompound tag = NBTHelper.openItemStackTag(stack);
        if (!tag.func_74764_b("te_curd_block")) {
            NBTTagCompound curdTag = new NBTTagCompound();
            Object cheeseType = this.getTypeForVariantID(CheeseUtils.getVariantIDFromMeta(stack.func_77952_i()));
            CheeseIO.writeToNBT(curdTag, cheeseType);
            tag.func_74782_a("te_curd_block", (NBTBase)curdTag);
        }
        return tag.func_74775_l("te_curd_block");
    }

    public ICheeseType getCheeseType(ItemStack stack) {
        NBTTagCompound tag = this.getTileTagCompoundABS(stack);
        return CheeseIO.loadFromNBT(tag);
    }

    @Override
    public void setTileTagCompound(ItemStack stack, NBTTagCompound tileTag) {
        NBTTagCompound tag = NBTHelper.openItemStackTag(stack);
        tag.func_74782_a("te_curd_block", (NBTBase)tileTag);
    }

    @Override
    public NBTTagCompound getTileTagCompound(ItemStack stack) {
        NBTTagCompound tag = this.getTileTagCompoundABS(stack);
        return tag;
    }

    public boolean isDried(ItemStack stack) {
        NBTTagCompound nbt = this.getTileTagCompound(stack);
        if (nbt.func_74764_b("dried")) {
            return nbt.func_74767_n("dried");
        }
        return false;
    }

    public String func_77667_c(ItemStack stack) {
        String str = super.func_77667_c(stack);
        str = str + "." + this.getCheeseType(stack).getRegistryName().func_110623_a();
        if (this.isDried(stack)) {
            str = str + ".dried";
        }
        return str;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        NBTTagCompound nbt = this.getTileTagCompound(stack);
        if (nbt.func_74764_b("dried") && nbt.func_74767_n("dried")) {
            tooltip.add(I18n.func_135052_a((String)"grcmilk.hanging_curds.dried", (Object[])new Object[0]));
        } else {
            int age = nbt.func_74762_e("age");
            if (age > 0) {
                int ageMax = nbt.func_74762_e("age_max");
                int t = age * 100 / (ageMax > 0 ? ageMax : 1200);
                tooltip.add(I18n.func_135052_a((String)"grcmilk.hanging_curds.drying.prefix", (Object[])new Object[0]) + I18n.func_135052_a((String)"grcmilk.hanging_curds.drying.progress.format", (Object[])new Object[]{t}));
            }
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public static NBTTagCompound openNBT(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlockHangingCurds) {
            return ((ItemBlockHangingCurds)item).getTileTagCompound(stack);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (ICheeseType type : this.getAllVariants()) {
            ICheeseCurdStackFactory curdStackFactory = type.getCurdBlocks();
            ItemStack stack = curdStackFactory.asStack();
            subItems.add((Object)stack);
        }
    }
}

