/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.io.nbt;

import growthcraft.core.shared.CoreRegistry;
import growthcraft.core.shared.effect.IEffect;
import growthcraft.core.shared.io.nbt.NBTType;
import growthcraft.core.shared.io.nbt.UnexpectedNBTTagTypeException;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class NBTHelper {
    private NBTHelper() {
    }

    public static int getInteger(@Nonnull NBTBase tag) {
        return tag != null && tag instanceof NBTPrimitive ? ((NBTPrimitive)tag).func_150287_d() : 0;
    }

    public static int getInteger(@Nonnull NBTTagCompound tag, String name) {
        return NBTHelper.getInteger(tag.func_74781_a(name));
    }

    public static NBTTagCompound compoundTagPresence(@Nullable NBTTagCompound tag) {
        if (tag != null && !tag.func_82582_d()) {
            return tag;
        }
        return null;
    }

    public static NBTTagCompound copyCompoundTag(@Nonnull NBTTagCompound tag) {
        NBTTagCompound newTag = tag.func_74737_b();
        return newTag;
    }

    public static NBTTagCompound openItemStackTag(@Nonnull ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            stack.func_77982_d(tag);
        }
        return tag;
    }

    public static NBTTagList writeInventorySlotsToNBT(@Nonnull ItemStack[] invSlots, @Nonnull NBTTagList invTags) {
        for (int i = 0; i < invSlots.length; ++i) {
            if (invSlots[i] == null) continue;
            NBTTagCompound slotTag = new NBTTagCompound();
            slotTag.func_74774_a("slot_id", (byte)i);
            invSlots[i].func_77955_b(slotTag);
            invTags.func_74742_a((NBTBase)slotTag);
        }
        return invTags;
    }

    public static NBTTagList writeInventorySlotsToNBT(@Nonnull ItemStack[] invSlots) {
        return NBTHelper.writeInventorySlotsToNBT(invSlots, new NBTTagList());
    }

    public static NBTTagList readInventorySlotsFromNBT(@Nonnull ItemStack[] invSlots, @Nonnull NBTTagList tags) {
        for (int i = 0; i < tags.func_74745_c(); ++i) {
            NBTTagCompound itemTag = tags.func_150305_b(i);
            byte slotID = itemTag.func_74771_c("slot_id");
            if (slotID < 0 || slotID >= invSlots.length) continue;
            invSlots[slotID] = new ItemStack(itemTag);
        }
        return tags;
    }

    public static NBTTagCompound writeIFluidHandlerToNBT(@Nonnull IFluidHandler fluidHandler, @Nonnull NBTTagCompound tag) {
        NBTTagList tankTagList = new NBTTagList();
        int tankId = 0;
        for (IFluidTankProperties tankProp : fluidHandler.getTankProperties()) {
            NBTTagCompound tankTag = new NBTTagCompound();
            tankTag.func_74768_a("tank_id", tankId);
            tankTag.func_74768_a("capacity", tankProp.getCapacity());
            FluidStack fluidStack = tankProp.getContents();
            if (fluidStack != null) {
                tankTag.func_74778_a("fluid_IDname", FluidRegistry.getFluidName((Fluid)fluidStack.getFluid()));
                NBTTagCompound fluidTag = new NBTTagCompound();
                fluidStack.writeToNBT(fluidTag);
                tankTag.func_74782_a("fluid", (NBTBase)fluidTag);
            } else {
                tankTag.func_74778_a("fluid_IDname", "");
            }
            tankTagList.func_74742_a((NBTBase)tankTag);
            ++tankId;
        }
        tag.func_74782_a("tanks", (NBTBase)tankTagList);
        tag.func_74768_a("tank_count", tankId);
        return tag;
    }

    public static NBTTagCompound writeItemStackToNBT(@Nullable ItemStack itemStack, @Nonnull NBTTagCompound tag) {
        if (itemStack != null) {
            itemStack.func_77955_b(tag);
        } else {
            tag.func_74768_a("id", 0);
        }
        return tag;
    }

    public static NBTTagCompound writeItemStackToNBT(@Nullable ItemStack itemStack) {
        return NBTHelper.writeItemStackToNBT(itemStack, new NBTTagCompound());
    }

    public static NBTTagCompound writeEffectsList(@Nonnull NBTTagCompound data, @Nonnull List<IEffect> list) {
        data.func_74768_a("size", list.size());
        NBTTagList effectsList = new NBTTagList();
        for (IEffect effect : list) {
            NBTTagCompound item = new NBTTagCompound();
            effect.writeToNBT(item, "value");
            effectsList.func_74742_a((NBTBase)item);
        }
        data.func_74782_a("effects", (NBTBase)effectsList);
        return data;
    }

    public static void loadEffectsList(@Nonnull List<IEffect> list, @Nonnull NBTTagCompound data) {
        int size = data.func_74762_e("size");
        NBTTagList effectsList = (NBTTagList)data.func_74781_a("effects");
        for (int i = 0; i < size; ++i) {
            NBTTagCompound effectData = effectsList.func_150305_b(i);
            IEffect effect = CoreRegistry.instance().getEffectsRegistry().loadEffectFromNBT(effectData, "value");
            list.add(effect);
        }
    }

    public static void writeIntegerCollection(@Nonnull NBTTagCompound data, @Nonnull Collection<Integer> coll) {
        data.func_74768_a("size", coll.size());
        int[] ary = new int[coll.size()];
        int i = 0;
        for (Integer num : coll) {
            ary[i] = num;
            ++i;
        }
        data.func_74782_a("data", (NBTBase)new NBTTagIntArray(ary));
    }

    public static void readIntegerCollection(@Nonnull Collection<Integer> coll, @Nonnull NBTTagCompound data) {
        NBTBase base = data.func_74781_a("data");
        if (base instanceof NBTTagIntArray) {
            NBTTagIntArray ary = (NBTTagIntArray)base;
            for (int i : ary.func_150302_c()) {
                coll.add(i);
            }
        } else {
            NBTType actual = NBTType.byId(base.func_74732_a());
            throw UnexpectedNBTTagTypeException.createFor((Object)NBTType.INT_ARRAY, (Object)actual);
        }
    }
}

