/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.crafting;

import appeng.api.AEApi;
import appeng.api.definitions.IBlocks;
import appeng.block.crafting.BlockCraftingUnit;
import appeng.tile.crafting.TileCraftingTile;
import java.util.Optional;
import net.minecraft.item.ItemStack;

public class TileCraftingStorageTile
extends TileCraftingTile {
    private static final int KILO_SCALAR = 1024;

    @Override
    protected ItemStack getItemFromTile(Object obj) {
        Optional<ItemStack> is;
        IBlocks blocks = AEApi.instance().definitions().blocks();
        int storage = ((TileCraftingTile)obj).getStorageBytes() / 1024;
        switch (storage) {
            case 1: {
                is = blocks.craftingStorage1k().maybeStack(1);
                break;
            }
            case 4: {
                is = blocks.craftingStorage4k().maybeStack(1);
                break;
            }
            case 16: {
                is = blocks.craftingStorage16k().maybeStack(1);
                break;
            }
            case 64: {
                is = blocks.craftingStorage64k().maybeStack(1);
                break;
            }
            default: {
                is = Optional.empty();
            }
        }
        return is.orElseGet(() -> super.getItemFromTile(obj));
    }

    @Override
    public boolean isAccelerator() {
        return false;
    }

    @Override
    public boolean isStorage() {
        return true;
    }

    @Override
    public int getStorageBytes() {
        if (this.field_145850_b == null || this.notLoaded() || this.func_145837_r()) {
            return 0;
        }
        BlockCraftingUnit unit = (BlockCraftingUnit)this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c();
        switch (unit.type) {
            default: {
                return 1024;
            }
            case STORAGE_4K: {
                return 4096;
            }
            case STORAGE_16K: {
                return 16384;
            }
            case STORAGE_64K: 
        }
        return 65536;
    }
}

