/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.parsers.machine;

import cofh.thermalexpansion.util.managers.machine.FurnaceManager;
import cofh.thermalexpansion.util.parsers.BaseParser;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import net.minecraft.item.ItemStack;

public class FurnaceParser
extends BaseParser {
    public static final String PYROLYSIS = "pyrolysis";
    public static final String CREOSOTE = "creosote";
    int defaultEnergy = 2000;
    Set<ItemStack> removeQueue = new ObjectOpenHashSet();
    Set<ItemStack> removeQueuePyrolysis = new ObjectOpenHashSet();

    @Override
    public void parseArray(JsonArray contentArray) {
        for (JsonElement recipe : contentArray) {
            JsonObject content = recipe.getAsJsonObject();
            if (content.has("//")) continue;
            int energy = this.defaultEnergy;
            ItemStack input = FurnaceParser.parseItemStack(content.get("input"));
            if (content.has("remove") && content.get("remove").getAsBoolean()) {
                String type;
                if (content.has("type") && (PYROLYSIS.equals(type = content.get("type").getAsString()) || content.has(CREOSOTE))) {
                    this.removeQueuePyrolysis.add(input);
                    continue;
                }
                this.removeQueue.add(input);
                continue;
            }
            ItemStack output = FurnaceParser.parseItemStack(content.get("output"));
            if (content.has("energy")) {
                energy = content.get("energy").getAsInt();
            } else if (content.has("energy_mod")) {
                energy = content.get("energy_mod").getAsInt() * this.defaultEnergy / 100;
            }
            if (content.has(CREOSOTE)) {
                int creosote = content.get(CREOSOTE).getAsInt();
                if (FurnaceManager.addRecipePyrolysis(energy, input, output, creosote) != null) {
                    ++this.parseCount;
                    continue;
                }
                ++this.errorCount;
                continue;
            }
            if (FurnaceManager.addRecipe(energy, input, output) != null) {
                ++this.parseCount;
                continue;
            }
            ++this.errorCount;
        }
    }

    @Override
    public void postProcess() {
        for (ItemStack stack : this.removeQueue) {
            FurnaceManager.removeRecipe(stack);
        }
        for (ItemStack stack : this.removeQueuePyrolysis) {
            FurnaceManager.removeRecipePyrolysis(stack);
        }
    }
}

