/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.machine;

import cofh.core.fluid.FluidTankCore;
import cofh.core.network.PacketBase;
import cofh.core.util.core.EnergyConfig;
import cofh.core.util.core.SideConfig;
import cofh.core.util.core.SlotConfig;
import cofh.core.util.helpers.AugmentHelper;
import cofh.core.util.helpers.FluidHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.block.machine.TileMachineBase;
import cofh.thermalexpansion.gui.client.machine.GuiBrewer;
import cofh.thermalexpansion.gui.container.machine.ContainerBrewer;
import cofh.thermalexpansion.util.managers.machine.BrewerManager;
import java.util.Arrays;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class TileBrewer
extends TileMachineBase {
    private static final int TYPE = BlockMachine.Type.BREWER.getMetadata();
    public static int basePower = 20;
    private BrewerManager.BrewerRecipe curRecipe;
    private int inputTracker;
    private int inputTrackerFluid;
    private int outputTrackerFluid;
    private FluidTankCore inputTank = new FluidTankCore(4000);
    private FluidTankCore outputTank = new FluidTankCore(10000);
    private FluidStack renderFluid = new FluidStack(FluidRegistry.WATER, 0);

    public static void initialize() {
        TileBrewer.SIDE_CONFIGS[TileBrewer.TYPE] = new SideConfig();
        TileBrewer.SIDE_CONFIGS[TileBrewer.TYPE].numConfig = 7;
        TileBrewer.SIDE_CONFIGS[TileBrewer.TYPE].slotGroups = new int[][]{new int[0], {0}, new int[0], {0}, new int[0], {0}, {0}};
        TileBrewer.SIDE_CONFIGS[TileBrewer.TYPE].sideTypes = new int[]{0, 1, 4, 5, 6, 7, 8};
        TileBrewer.SIDE_CONFIGS[TileBrewer.TYPE].defaultSides = new byte[]{1, 1, 2, 2, 2, 2};
        TileBrewer.ALT_SIDE_CONFIGS[TileBrewer.TYPE] = new SideConfig();
        TileBrewer.ALT_SIDE_CONFIGS[TileBrewer.TYPE].numConfig = 2;
        TileBrewer.ALT_SIDE_CONFIGS[TileBrewer.TYPE].slotGroups = new int[][]{new int[0], {0}, new int[0], {0}, {0}};
        TileBrewer.ALT_SIDE_CONFIGS[TileBrewer.TYPE].sideTypes = new int[]{0, 7};
        TileBrewer.ALT_SIDE_CONFIGS[TileBrewer.TYPE].defaultSides = new byte[]{1, 1, 1, 1, 1, 1};
        TileBrewer.SLOT_CONFIGS[TileBrewer.TYPE] = new SlotConfig();
        TileBrewer.SLOT_CONFIGS[TileBrewer.TYPE].allowInsertionSlot = new boolean[]{true, false};
        TileBrewer.SLOT_CONFIGS[TileBrewer.TYPE].allowExtractionSlot = new boolean[]{false, false};
        TileBrewer.VALID_AUGMENTS[TileBrewer.TYPE] = new HashSet();
        VALID_AUGMENTS[TYPE].add("machineBrewerReagent");
        TileBrewer.LIGHT_VALUES[TileBrewer.TYPE] = 12;
        GameRegistry.registerTileEntity(TileBrewer.class, (String)"thermalexpansion:machine_brewer");
        TileBrewer.config();
    }

    public static void config() {
        String category = "Machine.Brewer";
        BlockMachine.enable[TileBrewer.TYPE] = ThermalExpansion.CONFIG.get(category, "Enable", true);
        String comment = "Adjust this value to change the Energy consumption (in RF/t) for a BREWER. This base value will scale with block level and Augments.";
        basePower = ThermalExpansion.CONFIG.getConfiguration().getInt("BasePower", category, basePower, 10, 5000, comment);
        TileBrewer.ENERGY_CONFIGS[TileBrewer.TYPE] = new EnergyConfig();
        ENERGY_CONFIGS[TYPE].setDefaultParams(basePower, smallStorage);
    }

    public TileBrewer() {
        this.inventory = new ItemStack[2];
        Arrays.fill(this.inventory, ItemStack.field_190927_a);
        this.createAllSlots(this.inventory.length);
    }

    public int getType() {
        return TYPE;
    }

    @Override
    protected boolean canStart() {
        if (this.inventory[0].func_190926_b() || this.energyStorage.getEnergyStored() <= 0 || this.outputTank.getSpace() <= 0) {
            return false;
        }
        this.getRecipe();
        if (this.curRecipe == null) {
            return false;
        }
        if (this.inventory[0].func_190916_E() < this.curRecipe.getInput().func_190916_E()) {
            return false;
        }
        if (this.inputTank.getFluidAmount() < this.curRecipe.getInputFluid().amount) {
            return false;
        }
        FluidStack outputFluid = this.curRecipe.getOutputFluid();
        return this.outputTank.fill(outputFluid, false) == outputFluid.amount;
    }

    @Override
    protected boolean hasValidInput() {
        if (this.curRecipe == null) {
            this.getRecipe();
        }
        if (this.curRecipe == null) {
            return false;
        }
        return this.curRecipe.getInput().func_190916_E() <= this.inventory[0].func_190916_E();
    }

    @Override
    protected void clearRecipe() {
        this.curRecipe = null;
    }

    @Override
    protected void getRecipe() {
        this.curRecipe = BrewerManager.getRecipe(this.inventory[0], this.inputTank.getFluid());
    }

    @Override
    protected void processStart() {
        this.processRem = this.processMax = this.curRecipe.getEnergy() * this.energyMod / 100;
        FluidStack prevStack = this.renderFluid.copy();
        this.renderFluid = this.curRecipe.getOutputFluid().copy();
        this.renderFluid.amount = 0;
        if (!FluidHelper.isFluidEqual((FluidStack)prevStack, (FluidStack)this.renderFluid)) {
            this.sendFluidPacket();
        }
    }

    @Override
    protected void processFinish() {
        if (this.curRecipe == null) {
            this.getRecipe();
        }
        if (this.curRecipe == null) {
            this.processOff();
            return;
        }
        this.outputTank.fill(this.curRecipe.getOutputFluid(), true);
        this.inputTank.drain(this.curRecipe.getInputFluid().amount, true);
        int count = this.curRecipe.getInput().func_190916_E();
        if (this.reuseChance > 0) {
            if (this.field_145850_b.field_73012_v.nextInt(100) >= this.reuseChance) {
                this.inventory[0].func_190918_g(count);
            }
        } else {
            this.inventory[0].func_190918_g(count);
        }
        if (this.inventory[0].func_190916_E() <= 0) {
            this.inventory[0] = ItemStack.field_190927_a;
        }
    }

    @Override
    protected void transferInput() {
        if (!this.getTransferIn()) {
            return;
        }
        for (int i = this.inputTracker + 1; i <= this.inputTracker + 6; ++i) {
            int side = i % 6;
            if (!SideConfig.isPrimaryInput((int)this.sideConfig.sideTypes[this.sideCache[side]]) || !this.extractItem(0, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
            this.inputTracker = side;
            break;
        }
    }

    @Override
    protected void transferOutput() {
        if (!this.getTransferOut()) {
            return;
        }
        this.transferOutputFluid();
    }

    private void transferInputFluid() {
        if (this.inputTank.getSpace() <= 0) {
            return;
        }
        for (int i = this.inputTrackerFluid + 1; i <= this.inputTrackerFluid + 6; ++i) {
            int toFill;
            FluidStack input;
            int side = i % 6;
            if (!SideConfig.isSecondaryInput((int)this.sideConfig.sideTypes[this.sideCache[side]]) || (input = FluidHelper.extractFluidFromAdjacentFluidHandler((TileEntity)this, (EnumFacing)EnumFacing.field_82609_l[side], (int)FLUID_TRANSFER[this.level], (boolean)false)) == null || (toFill = this.inputTank.fill(input, true)) <= 0) continue;
            FluidHelper.extractFluidFromAdjacentFluidHandler((TileEntity)this, (EnumFacing)EnumFacing.field_82609_l[side], (int)toFill, (boolean)true);
            this.inputTracker = side;
            break;
        }
    }

    private void transferOutputFluid() {
        if (this.outputTank.getFluidAmount() <= 0) {
            return;
        }
        FluidStack output = new FluidStack(this.outputTank.getFluid(), Math.min(this.outputTank.getFluidAmount(), FLUID_TRANSFER[this.level]));
        for (int i = this.outputTrackerFluid + 1; i <= this.outputTrackerFluid + 6; ++i) {
            int toDrain;
            int side = i % 6;
            if (!SideConfig.isPrimaryOutput((int)this.sideConfig.sideTypes[this.sideCache[side]]) || (toDrain = FluidHelper.insertFluidIntoAdjacentFluidHandler((TileEntity)this, (EnumFacing)EnumFacing.field_82609_l[side], (FluidStack)output, (boolean)true)) <= 0) continue;
            this.outputTank.drain(toDrain, true);
            this.outputTrackerFluid = side;
            break;
        }
    }

    @Override
    public void func_73660_a() {
        if (this.timeCheckEighth()) {
            this.transferOutput();
        }
        super.func_73660_a();
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiBrewer(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerBrewer(inventory, (TileEntity)this);
    }

    public FluidTankCore getTank(int tankIndex) {
        if (tankIndex == 0) {
            return this.inputTank;
        }
        return this.outputTank;
    }

    public FluidStack getTankFluid(int tankIndex) {
        if (tankIndex == 0) {
            return this.inputTank.getFluid();
        }
        return this.outputTank.getFluid();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inputTracker = nbt.func_74762_e("TrackIn");
        this.inputTrackerFluid = nbt.func_74762_e("TrackInFluid");
        this.outputTrackerFluid = nbt.func_74762_e("TrackOutFluid");
        this.inputTank.readFromNBT(nbt.func_74775_l("TankIn"));
        this.outputTank.readFromNBT(nbt.func_74775_l("TankOut"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("TrackIn", this.inputTracker);
        nbt.func_74768_a("TrackInFluid", this.inputTrackerFluid);
        nbt.func_74768_a("TrackOutFluid", this.outputTrackerFluid);
        nbt.func_74782_a("TankIn", (NBTBase)this.inputTank.writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("TankOut", (NBTBase)this.outputTank.writeToNBT(new NBTTagCompound()));
        return nbt;
    }

    public PacketBase getFluidPacket() {
        PacketBase payload = super.getFluidPacket();
        payload.addFluidStack(this.renderFluid);
        return payload;
    }

    @Override
    public PacketBase getGuiPacket() {
        PacketBase payload = super.getGuiPacket();
        payload.addFluidStack(this.inputTank.getFluid());
        if (this.outputTank.getFluid() == null) {
            payload.addFluidStack(this.renderFluid);
        } else {
            payload.addFluidStack(this.outputTank.getFluid());
        }
        return payload;
    }

    protected void handleFluidPacket(PacketBase payload) {
        super.handleFluidPacket(payload);
        this.renderFluid = payload.getFluidStack();
        this.callBlockUpdate();
    }

    @Override
    protected void handleGuiPacket(PacketBase payload) {
        super.handleGuiPacket(payload);
        this.inputTank.setFluid(payload.getFluidStack());
        this.outputTank.setFluid(payload.getFluidStack());
    }

    @Override
    protected void preAugmentInstall() {
        super.preAugmentInstall();
    }

    @Override
    protected boolean installAugmentToSlot(int slot) {
        String id = AugmentHelper.getAugmentIdentifier((ItemStack)this.augments[slot]);
        if ("machineBrewerReagent".equals(id)) {
            this.reuseChance += 15;
            this.energyMod += 15;
        }
        return super.installAugmentToSlot(slot);
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot != 0 || BrewerManager.isItemValid(stack);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return super.hasCapability(capability, from) || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, final EnumFacing from) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new IFluidHandler(){

                public IFluidTankProperties[] getTankProperties() {
                    FluidTankInfo inputInfo = TileBrewer.this.inputTank.getInfo();
                    FluidTankInfo outputInfo = TileBrewer.this.outputTank.getInfo();
                    return new IFluidTankProperties[]{new FluidTankProperties(inputInfo.fluid, inputInfo.capacity, true, false), new FluidTankProperties(outputInfo.fluid, outputInfo.capacity, false, true)};
                }

                public int fill(FluidStack resource, boolean doFill) {
                    if (from == null || SideConfig.allowInsertion((int)((TileBrewer)TileBrewer.this).sideConfig.sideTypes[TileBrewer.this.sideCache[from.ordinal()]])) {
                        if (!BrewerManager.isFluidValid(resource)) {
                            return 0;
                        }
                        return TileBrewer.this.inputTank.fill(resource, doFill);
                    }
                    return 0;
                }

                @Nullable
                public FluidStack drain(FluidStack resource, boolean doDrain) {
                    if (from == null || SideConfig.allowExtraction((int)((TileBrewer)TileBrewer.this).sideConfig.sideTypes[TileBrewer.this.sideCache[from.ordinal()]])) {
                        FluidStack ret = TileBrewer.this.outputTank.drain(resource, doDrain);
                        if (ret != null) {
                            return ret;
                        }
                        if (!TileBrewer.this.isActive && (from == null || SideConfig.allowInsertion((int)((TileBrewer)TileBrewer.this).sideConfig.sideTypes[TileBrewer.this.sideCache[from.ordinal()]]))) {
                            return TileBrewer.this.inputTank.drain(resource, doDrain);
                        }
                    }
                    return null;
                }

                @Nullable
                public FluidStack drain(int maxDrain, boolean doDrain) {
                    if (from == null || SideConfig.allowExtraction((int)((TileBrewer)TileBrewer.this).sideConfig.sideTypes[TileBrewer.this.sideCache[from.ordinal()]])) {
                        FluidStack ret = TileBrewer.this.outputTank.drain(maxDrain, doDrain);
                        if (ret != null) {
                            return ret;
                        }
                        if (!TileBrewer.this.isActive && (from == null || SideConfig.allowInsertion((int)((TileBrewer)TileBrewer.this).sideConfig.sideTypes[TileBrewer.this.sideCache[from.ordinal()]]))) {
                            return TileBrewer.this.inputTank.drain(maxDrain, doDrain);
                        }
                    }
                    return null;
                }
            });
        }
        return (T)super.getCapability(capability, from);
    }
}

