/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.fluid;

import codechicken.lib.raytracer.RayTracer;
import cofh.core.network.PacketBase;
import cofh.core.network.PacketHandler;
import cofh.core.network.PacketTileInfo;
import cofh.core.util.helpers.BlockHelper;
import cofh.core.util.helpers.FluidHelper;
import cofh.core.util.helpers.ServerHelper;
import cofh.thermaldynamics.block.BlockDuct;
import cofh.thermaldynamics.duct.Attachment;
import cofh.thermaldynamics.duct.ConnectionType;
import cofh.thermaldynamics.duct.Duct;
import cofh.thermaldynamics.duct.attachments.filter.IFilterAttachment;
import cofh.thermaldynamics.duct.attachments.filter.IFilterFluid;
import cofh.thermaldynamics.duct.attachments.servo.ServoFluid;
import cofh.thermaldynamics.duct.fluid.GridFluid;
import cofh.thermaldynamics.duct.tiles.DuctToken;
import cofh.thermaldynamics.duct.tiles.DuctUnit;
import cofh.thermaldynamics.duct.tiles.IDuctHolder;
import cofh.thermaldynamics.duct.tiles.TileGrid;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DuctUnitFluid
extends DuctUnit<DuctUnitFluid, GridFluid, Cache> {
    private static DuctUnitFluid lightingUpdate = null;
    public byte internalSideCounter;
    public FluidStack mySavedFluid;
    public FluidStack myRenderFluid;
    public FluidStack fluidForGrid;
    public FluidStack myConnectionFluid;

    public DuctUnitFluid(TileGrid parent, Duct duct) {
        super(parent, duct);
    }

    protected Cache[] createTileCache() {
        return new Cache[6];
    }

    protected DuctUnitFluid[] createDuctCache() {
        return new DuctUnitFluid[6];
    }

    @Override
    public boolean tickPass(int pass) {
        if (!super.tickPass(pass)) {
            return false;
        }
        if (this.parent.attachmentData != null) {
            for (Attachment attachment : this.parent.attachmentData.attachments) {
                if (attachment == null || attachment.tickUnit() != DuctToken.FLUID) continue;
                attachment.tick(pass);
            }
        }
        if (this.grid == null) {
            return true;
        }
        if (pass == 0) {
            int i;
            int available = ((GridFluid)this.grid).toDistribute;
            int sent = 0;
            for (i = this.internalSideCounter; i < 6 && sent < available; ++i) {
                if ((sent += this.transfer(i, available - sent, false, ((GridFluid)this.grid).myTank.getFluid(), true)) < available) continue;
                this.internalSideCounter = this.tickInternalSideCounter(i + 1);
                break;
            }
            for (i = 0; i < this.internalSideCounter && sent < available; ++i) {
                if ((sent += this.transfer(i, available - sent, false, ((GridFluid)this.grid).myTank.getFluid(), true)) < available) continue;
                this.internalSideCounter = this.tickInternalSideCounter(i + 1);
                break;
            }
        }
        return true;
    }

    public int transfer(int available, boolean simulate, FluidStack base, boolean drainGridTank) {
        int i;
        int sent = 0;
        for (i = this.internalSideCounter; i < 6 && sent < available; ++i) {
            if ((sent += this.transfer(i, available - sent, simulate, base, drainGridTank)) < available) continue;
            this.internalSideCounter = this.tickInternalSideCounter(i + 1);
            break;
        }
        for (i = 0; i < this.internalSideCounter && sent < available; ++i) {
            if ((sent += this.transfer(i, available - sent, simulate, base, drainGridTank)) < available) continue;
            this.internalSideCounter = this.tickInternalSideCounter(i + 1);
            break;
        }
        return sent;
    }

    public int transfer(int bSide, int available, boolean simulate, FluidStack fluid, boolean drainGridTank) {
        if (fluid == null) {
            return 0;
        }
        Cache cache = ((Cache[])this.tileCache)[bSide];
        if (cache == null) {
            return 0;
        }
        EnumFacing facing = EnumFacing.field_82609_l[bSide ^ 1];
        if (!cache.tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing)) {
            return 0;
        }
        IFluidHandler capability = cache.getHandler(facing.ordinal());
        if (capability == null) {
            return 0;
        }
        if (!cache.filter.allowFluid(fluid)) {
            return 0;
        }
        FluidStack tempFluid = fluid.copy();
        tempFluid.amount = available;
        int amountSent = capability.fill(tempFluid, false);
        if (amountSent > 0) {
            if (simulate) {
                return amountSent;
            }
            if (drainGridTank) {
                tempFluid = ((GridFluid)this.grid).myTank.drain(amountSent, true);
            } else {
                tempFluid.amount = amountSent;
            }
            return capability.fill(tempFluid, true);
        }
        return 0;
    }

    @Override
    public int getLightValue() {
        if (this.isOpaque()) {
            return 0;
        }
        int fullEnough = 4;
        int level = Math.min(this.getRenderFluidLevel(), fullEnough);
        int light = FluidHelper.getFluidLuminosity((FluidStack)this.getConnectionFluid()) * level / fullEnough;
        if (lightingUpdate != null && lightingUpdate != this) {
            --light;
        }
        return light & ~light >> 31;
    }

    public void updateLighting() {
        lightingUpdate = this;
        this.parent.updateLighting();
        lightingUpdate = null;
    }

    public void updateFluid() {
        if (!this.isOpaque()) {
            this.sendRenderPacket();
        }
    }

    public FluidStack getFluidForGrid() {
        return this.fluidForGrid;
    }

    public void setFluidForGrid(FluidStack fluidForGrid) {
        this.fluidForGrid = fluidForGrid;
    }

    public boolean isOpaque() {
        return this.getDuctType().opaque;
    }

    @Override
    public boolean shouldRenderInPass(int pass) {
        return !this.getDuctType().opaque && this.myRenderFluid != null && super.shouldRenderInPass(pass);
    }

    public FluidStack getConnectionFluid() {
        if (ServerHelper.isClientWorld((World)this.parent.func_145831_w())) {
            return this.myRenderFluid;
        }
        return this.grid == null ? this.myConnectionFluid : ((GridFluid)this.grid).getFluid();
    }

    public boolean canStoreFluid() {
        return true;
    }

    @Override
    public void handleInfoPacket(PacketBase payload, boolean isServer, EntityPlayer thePlayer) {
        if (ServerHelper.isClientWorld((World)this.world())) {
            byte b = payload.getByte();
            this.handleTileInfoPacketType(payload, b);
        }
    }

    public void handleTileInfoPacketType(PacketBase payload, byte b) {
        if (b == 3) {
            this.myRenderFluid = payload.getFluidStack();
            BlockHelper.callBlockUpdate((World)this.world(), (BlockPos)this.pos());
        }
    }

    @Override
    @Nonnull
    public DuctToken<DuctUnitFluid, GridFluid, Cache> getToken() {
        return DuctToken.FLUID;
    }

    @Override
    public GridFluid createGrid() {
        return new GridFluid(this.world());
    }

    @Override
    public boolean canConnectToOtherDuct(DuctUnit<DuctUnitFluid, GridFluid, Cache> adjDuct, byte side, byte oppositeSide) {
        FluidStack connectionFluid;
        DuctUnitFluid ductUnitFluid = adjDuct.cast();
        FluidStack myFluid = this.getConnectionFluid();
        return myFluid == null || (connectionFluid = ductUnitFluid.getConnectionFluid()) == null || myFluid.isFluidEqual(connectionFluid);
    }

    @Override
    @Nullable
    public Cache cacheTile(@Nonnull TileEntity tile, byte side) {
        if (tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.field_82609_l[side ^ 1])) {
            Attachment attachment = this.parent.getAttachment(side);
            IFilterFluid filter = attachment instanceof IFilterAttachment ? ((IFilterAttachment)((Object)attachment)).getFluidFilter() : IFilterFluid.nullFilter;
            return new Cache(tile, filter);
        }
        return null;
    }

    public int getRenderFluidLevel() {
        if (this.myRenderFluid != null) {
            return this.myRenderFluid.amount;
        }
        if (this.grid == null) {
            if (this.myConnectionFluid != null) {
                return this.myConnectionFluid.amount;
            }
        } else {
            return ((GridFluid)this.grid).getRenderLevel();
        }
        return 0;
    }

    @Override
    public void writeToTilePacket(PacketBase payload) {
        if (this.grid != null) {
            payload.addFluidStack(((GridFluid)this.grid).getRenderFluid());
        } else {
            payload.addFluidStack(this.myConnectionFluid);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleTilePacket(PacketBase payload) {
        this.myRenderFluid = payload.getFluidStack();
    }

    public void sendRenderPacket() {
        if (this.grid == null) {
            return;
        }
        if (!this.getDuctType().opaque) {
            this.updateLighting();
            PacketTileInfo myPayload = this.newPacketTileInfo();
            myPayload.addByte((byte)3);
            myPayload.addFluidStack(((GridFluid)this.grid).getRenderFluid());
            PacketHandler.sendToAllAround((PacketBase)myPayload, (TileEntity)this.parent);
        }
    }

    public boolean matchesFilter(EnumFacing from, FluidStack resource) {
        Cache cache = ((Cache[])this.tileCache)[from.ordinal()];
        return from == null || cache == null || cache.filter.allowFluid(resource);
    }

    public boolean isOpen(EnumFacing from) {
        return this.grid != null && (from == null || (this.isOutput(from.ordinal()) || this.isInput(from.ordinal())) && this.parent.getConnectionType((int)from.ordinal()).allowTransfer);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        if (this.grid != null && ((GridFluid)this.grid).hasValidFluid()) {
            this.mySavedFluid = ((GridFluid)this.grid).getNodeShare(this);
            if (this.mySavedFluid != null) {
                this.mySavedFluid.writeToNBT(nbt);
            }
            nbt.func_74782_a("ConnFluid", (NBTBase)new NBTTagCompound());
            this.myConnectionFluid = ((GridFluid)this.grid).getConnectionFluid();
            this.myConnectionFluid.writeToNBT(nbt.func_74775_l("ConnFluid"));
        } else {
            this.mySavedFluid = null;
            this.myConnectionFluid = null;
        }
        return nbt;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.fluidForGrid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt);
        if (nbt.func_74764_b("ConnFluid")) {
            this.myConnectionFluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("ConnFluid"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPlaced(EntityLivingBase living, ItemStack stack) {
        if (ServerHelper.isClientWorld((World)this.world())) {
            return;
        }
        FluidStack fluidStack = null;
        if (living instanceof EntityPlayer) {
            RayTraceResult retrace;
            EntityPlayer player = (EntityPlayer)living;
            try {
                BlockDuct.IGNORE_RAY_TRACE.set(this.pos());
                retrace = RayTracer.retrace((EntityPlayer)player, (boolean)false);
            }
            finally {
                BlockDuct.IGNORE_RAY_TRACE.set(null);
            }
            if (retrace != null && retrace.field_178784_b != null) {
                EnumFacing sideHit = retrace.field_178784_b.func_176734_d();
                DuctUnitFluid fluids = IDuctHolder.getTokenFromTile(this.world().func_175625_s(this.pos().func_177972_a(sideHit)), DuctToken.FLUID);
                if (fluids != null) {
                    fluidStack = fluids.getConnectionFluid();
                }
            }
        }
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            TileEntity tileEntity = this.world().func_175625_s(this.pos().func_177972_a(facing));
            DuctUnitFluid fluids = IDuctHolder.getTokenFromTile(tileEntity, DuctToken.FLUID);
            if (fluids == null) continue;
            FluidStack connectionFluid = fluids.getConnectionFluid();
            if (fluidStack == null) {
                fluidStack = connectionFluid;
                continue;
            }
            if (connectionFluid == null || fluidStack.isFluidEqual(connectionFluid)) continue;
            this.parent.setConnectionType(facing.ordinal(), ConnectionType.BLOCKED);
            ((TileGrid)tileEntity).setConnectionType(facing.ordinal() ^ 1, ConnectionType.BLOCKED);
            ((TileGrid)tileEntity).callBlockUpdate();
        }
    }

    @Override
    public boolean isInputTile(@Nullable TileEntity tile, byte side) {
        return !(tile instanceof IDuctHolder) && this.parent.getAttachment(side) instanceof ServoFluid;
    }

    public int[] getRenderFluidConnections() {
        int[] connections = new int[6];
        for (int i = 0; i < 6; ++i) {
            connections[i] = this.parent.getVisualConnectionType(i).ordinal();
        }
        return connections;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.getFluidCapability(facing));
    }

    public IFluidHandler getFluidCapability(final EnumFacing from) {
        if (this.grid == null) {
            return EmptyFluidHandler.INSTANCE;
        }
        return (IFluidHandler)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new IFluidHandler(){

            public IFluidTankProperties[] getTankProperties() {
                FluidStack info = DuctUnitFluid.this.grid != null ? ((GridFluid)((DuctUnitFluid)DuctUnitFluid.this).grid).myTank.getInfo().fluid : null;
                int capacity = DuctUnitFluid.this.grid != null ? ((GridFluid)((DuctUnitFluid)DuctUnitFluid.this).grid).myTank.getInfo().capacity : 0;
                return new IFluidTankProperties[]{new FluidTankProperties(info, capacity, DuctUnitFluid.this.isOpen(from), DuctUnitFluid.this.isOpen(from))};
            }

            public int fill(FluidStack resource, boolean doFill) {
                if (resource != null && DuctUnitFluid.this.isOpen(from) && DuctUnitFluid.this.matchesFilter(from, resource)) {
                    return ((GridFluid)((DuctUnitFluid)DuctUnitFluid.this).grid).myTank.fill(resource, doFill);
                }
                return 0;
            }

            @Nullable
            public FluidStack drain(FluidStack resource, boolean doDrain) {
                if (DuctUnitFluid.this.isOpen(from)) {
                    return ((GridFluid)((DuctUnitFluid)DuctUnitFluid.this).grid).myTank.drain(resource, doDrain);
                }
                return null;
            }

            @Nullable
            public FluidStack drain(int maxDrain, boolean doDrain) {
                if (DuctUnitFluid.this.isOpen(from)) {
                    return ((GridFluid)((DuctUnitFluid)DuctUnitFluid.this).grid).myTank.drain(maxDrain, doDrain);
                }
                return null;
            }
        });
    }

    public class TileFluidPackets {
        public static final byte GUI_BUTTON = 0;
        public static final byte SET_FILTER = 1;
        public static final byte FILTERS = 2;
        public static final byte UPDATE_RENDER = 3;
        public static final byte TEMPERATURE = 4;
    }

    public static class Cache {
        public TileEntity tile;
        public IFilterFluid filter;

        public Cache(TileEntity tile, @Nonnull IFilterFluid filter) {
            this.tile = tile;
            this.filter = filter;
        }

        public IFluidHandler getHandler(int side) {
            if (this.tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.field_82609_l[side])) {
                return (IFluidHandler)this.tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.field_82609_l[side]);
            }
            return null;
        }
    }
}

