/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.plug;

import buildcraft.api.facades.FacadeType;
import buildcraft.api.facades.IFacade;
import buildcraft.api.facades.IFacadePhasedState;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.silicon.plug.FacadeBlockStateInfo;
import buildcraft.silicon.plug.FacadePhasedState;
import buildcraft.silicon.plug.FacadeStateManager;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;

public class FacadeInstance
implements IFacade {
    public final FacadePhasedState[] phasedStates;
    public final FacadeType type;
    public final boolean isHollow;

    public FacadeInstance(FacadePhasedState[] phasedStates, boolean isHollow) {
        if (phasedStates == null) {
            throw new NullPointerException("phasedStates");
        }
        if (phasedStates.length == 0) {
            throw new IllegalArgumentException("phasedStates.length was 0");
        }
        if (phasedStates.length > 17) {
            throw new IllegalArgumentException("phasedStates.length was > 17");
        }
        this.phasedStates = phasedStates;
        this.type = phasedStates.length == 1 ? FacadeType.Basic : FacadeType.Phased;
        this.isHollow = isHollow;
    }

    public static FacadeInstance createSingle(FacadeBlockStateInfo info, boolean isHollow) {
        return new FacadeInstance(new FacadePhasedState[]{new FacadePhasedState(info, null)}, isHollow);
    }

    public static FacadeInstance readFromNbt(NBTTagCompound nbt) {
        NBTTagList list = nbt.func_150295_c("states", 10);
        if (list.func_82582_d()) {
            return FacadeInstance.createSingle(FacadeStateManager.defaultState, false);
        }
        FacadePhasedState[] states = new FacadePhasedState[list.func_74745_c()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            states[i] = FacadePhasedState.readFromNbt(list.func_150305_b(i));
        }
        boolean hollow = nbt.func_74767_n("isHollow");
        return new FacadeInstance(states, hollow);
    }

    public NBTTagCompound writeToNbt() {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (FacadePhasedState state : this.phasedStates) {
            list.func_74742_a((NBTBase)state.writeToNbt());
        }
        nbt.func_74782_a("states", (NBTBase)list);
        nbt.func_74757_a("isHollow", this.isHollow);
        return nbt;
    }

    public static FacadeInstance readFromBuffer(PacketBufferBC buf) {
        boolean isHollow = buf.readBoolean();
        int count = buf.readFixedBits(5);
        FacadePhasedState[] states = new FacadePhasedState[count];
        for (int i = 0; i < count; ++i) {
            states[i] = FacadePhasedState.readFromBuffer(buf);
        }
        return new FacadeInstance(states, isHollow);
    }

    public void writeToBuffer(PacketBufferBC buf) {
        buf.writeBoolean(this.isHollow);
        buf.writeFixedBits(this.phasedStates.length, 5);
        for (FacadePhasedState phasedState : this.phasedStates) {
            phasedState.writeToBuffer(buf);
        }
    }

    public boolean canAddColour(EnumDyeColor colour) {
        for (FacadePhasedState state : this.phasedStates) {
            if (state.activeColour != colour) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public FacadeInstance withState(FacadePhasedState state) {
        if (this.canAddColour(state.activeColour)) {
            FacadePhasedState[] newStates = Arrays.copyOf(this.phasedStates, this.phasedStates.length + 1);
            newStates[newStates.length - 1] = state;
            return new FacadeInstance(newStates, this.isHollow);
        }
        return null;
    }

    public FacadePhasedState getCurrentStateForStack() {
        int count = this.phasedStates.length;
        if (count == 1) {
            return this.phasedStates[0];
        }
        int now = (int)(System.currentTimeMillis() % 100000L);
        return this.phasedStates[now / 500 % count];
    }

    public FacadeInstance withSwappedIsHollow() {
        return new FacadeInstance(this.phasedStates, !this.isHollow);
    }

    public boolean areAllStatesSolid(EnumFacing side) {
        for (FacadePhasedState state : this.phasedStates) {
            if (state.isSideSolid(side)) continue;
            return false;
        }
        return true;
    }

    public BlockFaceShape getBlockFaceShape(EnumFacing side) {
        if (this.isHollow()) {
            return BlockFaceShape.UNDEFINED;
        }
        switch (this.type) {
            case Basic: {
                return this.phasedStates[0].getBlockFaceShape(side);
            }
            case Phased: {
                BlockFaceShape shape = null;
                for (FacadePhasedState state : this.phasedStates) {
                    if (shape == null) {
                        shape = state.getBlockFaceShape(side);
                        continue;
                    }
                    if (shape == state.getBlockFaceShape(side)) continue;
                    return BlockFaceShape.UNDEFINED;
                }
                if (shape == null) {
                    return BlockFaceShape.UNDEFINED;
                }
                return shape;
            }
        }
        throw new IllegalStateException("Unknown FacadeType " + this.type);
    }

    public FacadeType getType() {
        return this.type;
    }

    public boolean isHollow() {
        return this.isHollow;
    }

    public IFacadePhasedState[] getPhasedStates() {
        return this.phasedStates;
    }
}

