/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.client.model.block;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.machinemuse.numina.client.model.helper.MuseModelHelper;
import net.machinemuse.numina.math.Colour;
import net.machinemuse.powersuits.block.BlockLuxCapacitor;
import net.machinemuse.powersuits.client.event.MuseIcon;
import net.machinemuse.powersuits.client.model.helper.ColoredQuadHelperThingie;
import net.machinemuse.powersuits.client.model.helper.ModelLuxCapacitorHelper;
import net.machinemuse.powersuits.common.MPSItems;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

@SideOnly(value=Side.CLIENT)
public class ModelLuxCapacitor
implements IBakedModel {
    public static final ModelResourceLocation modelResourceLocation = new ModelResourceLocation(MPSItems.luxCapacitor.getRegistryName().toString());
    final IModelState modelState;
    public IBakedModel wrapper;
    protected Function<ResourceLocation, TextureAtlasSprite> textureGetter;
    Colour colour;
    private LuxCapacitorItemOverrideList overrides = new LuxCapacitorItemOverrideList();

    public ModelLuxCapacitor() {
        this.wrapper = this;
        this.modelState = this.getModelState();
    }

    public static ModelResourceLocation getModelResourceLocation(EnumFacing facing) {
        return new ModelResourceLocation(MPSItems.luxCapacitor.getRegistryName().toString(), "facing=" + facing.func_176610_l());
    }

    IModelState getModelState() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)MuseModelHelper.get((float)1.13f, (float)3.2f, (float)1.13f, (float)-25.0f, (float)-90.0f, (float)0.0f, (float)0.41f));
        builder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)MuseModelHelper.get((float)0.0f, (float)2.0f, (float)3.0f, (float)0.0f, (float)0.0f, (float)45.0f, (float)0.5f));
        builder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)MuseModelHelper.get((float)1.13f, (float)3.2f, (float)1.13f, (float)-25.0f, (float)-90.0f, (float)0.0f, (float)0.41f));
        builder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)MuseModelHelper.get((float)0.0f, (float)2.0f, (float)3.0f, (float)0.0f, (float)0.0f, (float)45.0f, (float)0.5f));
        builder.put((Object)ItemCameraTransforms.TransformType.GUI, (Object)MuseModelHelper.get((float)0.0f, (float)2.75f, (float)0.0f, (float)-45.0f, (float)0.0f, (float)45.0f, (float)0.75f));
        builder.put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)MuseModelHelper.get((float)0.0f, (float)2.0f, (float)0.0f, (float)-90.0f, (float)-0.0f, (float)0.0f, (float)0.5f));
        builder.put((Object)ItemCameraTransforms.TransformType.FIXED, (Object)MuseModelHelper.get((float)0.0f, (float)0.0f, (float)-7.5f, (float)0.0f, (float)180.0f, (float)0.0f, (float)1.0f));
        return new SimpleModelState(builder.build());
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        if (side != null) {
            return Collections.emptyList();
        }
        EnumFacing facing = EnumFacing.NORTH;
        this.colour = BlockLuxCapacitor.defaultColor;
        if (state != null) {
            facing = (EnumFacing)state.func_177229_b((IProperty)BlockDirectional.field_176387_N);
            if (state instanceof IExtendedBlockState && ((IExtendedBlockState)state).getUnlistedProperties().containsKey(BlockLuxCapacitor.COLOR)) {
                this.colour = (Colour)((IExtendedBlockState)state).getValue(BlockLuxCapacitor.COLOR);
            }
        }
        if (this.colour == null) {
            this.colour = BlockLuxCapacitor.defaultColor;
        }
        ColoredQuadHelperThingie helperThingie = new ColoredQuadHelperThingie(this.colour, facing);
        try {
            return (List)ModelLuxCapacitorHelper.luxCapColoredQuadMap.get((Object)helperThingie);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return MuseIcon.luxCapacitorTexture;
    }

    public ItemOverrideList func_188617_f() {
        return this.overrides;
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        TRSRTransformation transform = this.modelState.apply(Optional.of(cameraTransformType)).orElse(TRSRTransformation.identity());
        if (transform != TRSRTransformation.identity()) {
            return Pair.of(this, transform.getMatrix());
        }
        return Pair.of(this, transform.getMatrix());
    }

    private class LuxCapacitorItemOverrideList
    extends ItemOverrideList {
        private LuxCapacitorItemOverrideList() {
            super((List)ImmutableList.of());
        }

        @Nonnull
        public IBakedModel handleItemState(@Nonnull IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            return ModelLuxCapacitor.this.wrapper;
        }
    }
}

