/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.snapshot;

import buildcraft.api.core.EnumHandlerPriority;
import buildcraft.api.template.ITemplateHandler;
import buildcraft.api.template.ITemplateRegistry;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public enum TemplateRegistry implements ITemplateRegistry
{
    INSTANCE;

    private final EnumMap<EnumHandlerPriority, List<ITemplateHandler>> handlers = new EnumMap(EnumHandlerPriority.class);

    private TemplateRegistry() {
        for (EnumHandlerPriority priority : EnumHandlerPriority.VALUES) {
            this.handlers.put(priority, new ArrayList());
        }
    }

    public void addHandler(ITemplateHandler handler, EnumHandlerPriority priority) {
        this.handlers.get(priority).add(handler);
    }

    public boolean handle(World world, BlockPos pos, EntityPlayer player, ItemStack stack) {
        for (EnumHandlerPriority priority : EnumHandlerPriority.VALUES) {
            for (ITemplateHandler handler : this.handlers.get(priority)) {
                if (!handler.handle(world, pos, player, stack)) continue;
                return true;
            }
        }
        return false;
    }
}

