/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.block;

import buildcraft.api.properties.BuildCraftProperties;
import buildcraft.builders.block.BlockQuarry;
import buildcraft.lib.block.BlockBCBase_Neptune;
import buildcraft.lib.misc.RotationUtil;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockFrame
extends BlockBCBase_Neptune {
    public static final Map<EnumFacing, IProperty<Boolean>> CONNECTED_MAP = BuildCraftProperties.CONNECTED_MAP;
    public static final AxisAlignedBB BASE_AABB = new AxisAlignedBB(0.25, 0.25, 0.25, 0.75, 0.75, 0.75);
    public static final AxisAlignedBB CONNECTION_AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.25, 0.75);

    public BlockFrame(Material material, String id) {
        super(material, id);
    }

    protected void addProperties(List<IProperty<?>> properties) {
        super.addProperties(properties);
        properties.addAll(CONNECTED_MAP.values());
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        Iterator<EnumFacing> iterator = CONNECTED_MAP.keySet().iterator();
        while (iterator.hasNext()) {
            Block block;
            EnumFacing side;
            state = state.func_177226_a(CONNECTED_MAP.get(side), (Comparable)Boolean.valueOf((block = world.func_180495_p(pos.func_177972_a(side = iterator.next())).func_177230_c()) instanceof BlockFrame || block instanceof BlockQuarry));
        }
        return state;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        IBlockState actualState = state.func_185899_b(world, pos);
        EnumFacing[] facings = (EnumFacing[])CONNECTED_MAP.keySet().stream().filter(facing -> (Boolean)actualState.func_177229_b(CONNECTED_MAP.get(facing))).toArray(EnumFacing[]::new);
        if (facings.length == 1) {
            return side != facings[0];
        }
        if (facings.length == 2 && facings[0] == facings[1].func_176734_d()) {
            return side != facings[0] && side != facings[1];
        }
        return true;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState actualState = state.func_185899_b(world, pos);
        AtomicReference<AxisAlignedBB> box = new AtomicReference<AxisAlignedBB>(BASE_AABB);
        CONNECTED_MAP.forEach((side, property) -> {
            if (((Boolean)actualState.func_177229_b(property)).booleanValue()) {
                box.set(((AxisAlignedBB)box.get()).func_111270_a(RotationUtil.rotateAABB((AxisAlignedBB)CONNECTION_AABB, (EnumFacing)side)));
            }
        });
        return box.get();
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entity, boolean isPistonMoving) {
        IBlockState actualState = state.func_185899_b((IBlockAccess)world, pos);
        BlockFrame.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BASE_AABB);
        CONNECTED_MAP.keySet().stream().filter(side -> (Boolean)actualState.func_177229_b(CONNECTED_MAP.get(side))).map(side -> RotationUtil.rotateAABB((AxisAlignedBB)CONNECTION_AABB, (EnumFacing)side)).forEach(box -> BlockFrame.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, (List)collidingBoxes, (AxisAlignedBB)box));
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return Collections.emptyList();
    }
}

