/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.util;

import codechicken.lib.math.MathHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class RotationUtils {
    public static EnumFacing getPlacedRotationHorizontal(EntityLivingBase entity) {
        int facing = MathHelper.floor((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5) & 3;
        return RotationUtils.entityRotationToSide(facing).func_176734_d();
    }

    public static EnumFacing getPlacedRotation(BlockPos pos, EntityLivingBase entity) {
        int entityRotation = (int)Math.floor((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5) & 3;
        if (Math.abs(entity.field_70165_t - (double)pos.func_177958_n()) < 2.0 && Math.abs(entity.field_70161_v - (double)pos.func_177952_p()) < 2.0) {
            double eyeDistance = entity.field_70163_u + 1.82 - (double)pos.func_177956_o();
            if (eyeDistance > 2.0) {
                return EnumFacing.DOWN;
            }
            if (eyeDistance < 0.0) {
                return EnumFacing.UP;
            }
        }
        return RotationUtils.entityRotationToSide(entityRotation);
    }

    public static EnumFacing getPlacedRotation(BlockPos pos, EntityLivingBase entity, boolean onlyHorizon) {
        if (onlyHorizon) {
            return RotationUtils.getPlacedRotationHorizontal(entity);
        }
        return RotationUtils.getPlacedRotation(pos, entity);
    }

    public static EnumFacing rotateCounterClockwise(EnumFacing facing) {
        switch (facing) {
            case NORTH: {
                return EnumFacing.WEST;
            }
            case EAST: {
                return EnumFacing.NORTH;
            }
            case SOUTH: {
                return EnumFacing.EAST;
            }
            case WEST: {
                return EnumFacing.SOUTH;
            }
        }
        throw new IllegalStateException("Unable to get CCW facing of " + facing);
    }

    public static EnumFacing rotateClockwise(EnumFacing facing) {
        switch (facing) {
            case NORTH: {
                return EnumFacing.EAST;
            }
            case EAST: {
                return EnumFacing.SOUTH;
            }
            case SOUTH: {
                return EnumFacing.WEST;
            }
            case WEST: {
                return EnumFacing.NORTH;
            }
        }
        throw new IllegalStateException("Unable to get CW facing of " + facing);
    }

    public static EnumFacing rotateForward(EnumFacing facing) {
        switch (facing) {
            case NORTH: {
                return EnumFacing.DOWN;
            }
            case DOWN: {
                return EnumFacing.UP;
            }
            case UP: {
                return EnumFacing.WEST;
            }
            case WEST: {
                return EnumFacing.EAST;
            }
            case EAST: {
                return EnumFacing.SOUTH;
            }
            case SOUTH: {
                return EnumFacing.NORTH;
            }
        }
        return EnumFacing.NORTH;
    }

    public static EnumFacing rotateBackwards(EnumFacing facing) {
        switch (facing) {
            case NORTH: {
                return EnumFacing.SOUTH;
            }
            case SOUTH: {
                return EnumFacing.EAST;
            }
            case EAST: {
                return EnumFacing.WEST;
            }
            case WEST: {
                return EnumFacing.UP;
            }
            case UP: {
                return EnumFacing.DOWN;
            }
            case DOWN: {
                return EnumFacing.NORTH;
            }
        }
        return EnumFacing.NORTH;
    }

    public static EnumFacing entityRotationToSide(int rotation) {
        switch (rotation) {
            case 0: {
                return EnumFacing.SOUTH;
            }
            case 1: {
                return EnumFacing.WEST;
            }
            case 2: {
                return EnumFacing.NORTH;
            }
        }
        return EnumFacing.EAST;
    }
}

