/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world;

import biomesoplenty.api.config.IBOPWorldSettings;
import biomesoplenty.api.config.IConfigObj;
import biomesoplenty.common.util.config.BOPConfig;
import biomesoplenty.core.BiomesOPlenty;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.Locale;

public class BOPWorldSettings
implements IBOPWorldSettings {
    public static Gson serializer = new GsonBuilder().create();
    public LandMassScheme landScheme = LandMassScheme.VANILLA;
    public TemperatureVariationScheme tempScheme = TemperatureVariationScheme.MEDIUM_ZONES;
    public RainfallVariationScheme rainScheme = RainfallVariationScheme.MEDIUM_ZONES;
    public BiomeSize biomeSize = BiomeSize.MEDIUM;
    public float amplitude = 1.0f;
    public boolean generateBopGems = true;
    public boolean generatePoisonIvy = false;
    public boolean generateBerryBushes = true;
    public boolean generateThorns = true;
    public boolean generateQuicksand = true;
    public boolean generateLiquidPoison = true;
    public boolean generateHotSprings = true;
    public boolean generateNetherHives = true;
    public boolean generateEndFeatures = true;
    public int seaLevel;
    public boolean useCaves;
    public boolean useDungeons;
    public int dungeonChance;
    public boolean useStrongholds;
    public boolean useVillages;
    public boolean useMineShafts;
    public boolean useTemples;
    public boolean useMonuments;
    public boolean useRavines;
    public boolean useWaterLakes;
    public int waterLakeChance;
    public boolean useLavaLakes;
    public int lavaLakeChance;
    public boolean useLavaOceans;
    public boolean useMansions;
    public float coordinateScale;
    public float heightScale;
    public float upperLimitScale;
    public float lowerLimitScale;
    public float mainNoiseScaleX;
    public float mainNoiseScaleY;
    public float mainNoiseScaleZ;

    public BOPWorldSettings() {
        this.setDefault();
    }

    public BOPWorldSettings(String jsonString) {
        this.setDefault();
        this.fromJson(jsonString);
    }

    public String toJson() {
        JsonObject obj = new JsonObject();
        obj.addProperty("landScheme", this.landScheme.name().toLowerCase(Locale.ENGLISH));
        obj.addProperty("tempScheme", this.tempScheme.name().toLowerCase(Locale.ENGLISH));
        obj.addProperty("rainScheme", this.rainScheme.name().toLowerCase(Locale.ENGLISH));
        obj.addProperty("biomeSize", this.biomeSize.name().toLowerCase(Locale.ENGLISH));
        obj.addProperty("amplitude", (Number)Float.valueOf(this.amplitude));
        obj.addProperty("generateBopOre", Boolean.valueOf(this.generateBopGems));
        obj.addProperty("generatePoisonIvy", Boolean.valueOf(this.generatePoisonIvy));
        obj.addProperty("generateBerryBushes", Boolean.valueOf(this.generateBerryBushes));
        obj.addProperty("generateThorns", Boolean.valueOf(this.generateThorns));
        obj.addProperty("generateQuicksand", Boolean.valueOf(this.generateQuicksand));
        obj.addProperty("generateLiquidPoison", Boolean.valueOf(this.generateLiquidPoison));
        obj.addProperty("generateHotSprings", Boolean.valueOf(this.generateHotSprings));
        obj.addProperty("generateNetherHives", Boolean.valueOf(this.generateNetherHives));
        obj.addProperty("generateEndFeatures", Boolean.valueOf(this.generateEndFeatures));
        obj.addProperty("mainNoiseScaleX", (Number)Float.valueOf(this.mainNoiseScaleX));
        obj.addProperty("mainNoiseScaleY", (Number)Float.valueOf(this.mainNoiseScaleY));
        obj.addProperty("mainNoiseScaleZ", (Number)Float.valueOf(this.mainNoiseScaleZ));
        obj.addProperty("coordinateScale", (Number)Float.valueOf(this.coordinateScale));
        obj.addProperty("heightScale", (Number)Float.valueOf(this.heightScale));
        obj.addProperty("upperLimitScale", (Number)Float.valueOf(this.upperLimitScale));
        obj.addProperty("lowerLimitScale", (Number)Float.valueOf(this.lowerLimitScale));
        return serializer.toJson((JsonElement)obj);
    }

    public void fromJson(String jsonString) {
        this.fromConfigObj(new BOPConfig.ConfigObj(jsonString));
    }

    public void fromConfigObj(IConfigObj worldConfig) {
        this.landScheme = worldConfig.getEnum("landScheme", this.landScheme, LandMassScheme.class);
        this.tempScheme = worldConfig.getEnum("tempScheme", this.tempScheme, TemperatureVariationScheme.class);
        this.rainScheme = worldConfig.getEnum("rainScheme", this.rainScheme, RainfallVariationScheme.class);
        this.biomeSize = worldConfig.getEnum("biomeSize", this.biomeSize, BiomeSize.class);
        this.amplitude = worldConfig.getFloat("amplitude", Float.valueOf(this.amplitude)).floatValue();
        this.generateBopGems = worldConfig.getBool("generateBopOre", this.generateBopGems);
        this.generatePoisonIvy = worldConfig.getBool("generatePoisonIvy", this.generatePoisonIvy);
        this.generateBerryBushes = worldConfig.getBool("generateBerryBushes", this.generateBerryBushes);
        this.generateThorns = worldConfig.getBool("generateThorns", this.generateThorns);
        this.generateQuicksand = worldConfig.getBool("generateQuicksand", this.generateQuicksand);
        this.generateLiquidPoison = worldConfig.getBool("generateLiquidPoison", this.generateLiquidPoison);
        this.generateHotSprings = worldConfig.getBool("generateHotSprings", this.generateHotSprings);
        this.generateNetherHives = worldConfig.getBool("generateNetherHives", this.generateNetherHives);
        this.generateEndFeatures = worldConfig.getBool("generateEndFeatures", this.generateEndFeatures);
        this.mainNoiseScaleX = worldConfig.getFloat("mainNoiseScaleX", Float.valueOf(this.mainNoiseScaleX)).floatValue();
        this.mainNoiseScaleY = worldConfig.getFloat("mainNoiseScaleY", Float.valueOf(this.mainNoiseScaleY)).floatValue();
        this.mainNoiseScaleZ = worldConfig.getFloat("mainNoiseScaleZ", Float.valueOf(this.mainNoiseScaleZ)).floatValue();
        this.coordinateScale = worldConfig.getFloat("coordinateScale", Float.valueOf(this.coordinateScale)).floatValue();
        this.heightScale = worldConfig.getFloat("heightScale", Float.valueOf(this.heightScale)).floatValue();
        this.upperLimitScale = worldConfig.getFloat("upperLimitScale", Float.valueOf(this.upperLimitScale)).floatValue();
        this.lowerLimitScale = worldConfig.getFloat("lowerLimitScale", Float.valueOf(this.lowerLimitScale)).floatValue();
    }

    public void setDefault() {
        this.landScheme = LandMassScheme.VANILLA;
        this.tempScheme = TemperatureVariationScheme.MEDIUM_ZONES;
        this.rainScheme = RainfallVariationScheme.MEDIUM_ZONES;
        this.biomeSize = BiomeSize.MEDIUM;
        this.amplitude = 1.0f;
        this.generateBopGems = true;
        this.generatePoisonIvy = false;
        this.generateBerryBushes = true;
        this.generateThorns = true;
        this.generateQuicksand = true;
        this.generateLiquidPoison = true;
        this.generateHotSprings = true;
        this.generateNetherHives = true;
        this.generateEndFeatures = true;
        this.seaLevel = 63;
        this.useCaves = true;
        this.useDungeons = true;
        this.dungeonChance = 8;
        this.useStrongholds = true;
        this.useVillages = true;
        this.useMineShafts = true;
        this.useTemples = true;
        this.useMonuments = true;
        this.useMansions = true;
        this.useRavines = true;
        this.useWaterLakes = true;
        this.waterLakeChance = 4;
        this.useLavaLakes = true;
        this.lavaLakeChance = 80;
        this.useLavaOceans = false;
        this.mainNoiseScaleX = 80.0f;
        this.mainNoiseScaleY = 160.0f;
        this.mainNoiseScaleZ = 80.0f;
        this.coordinateScale = 684.412f;
        this.heightScale = 684.412f;
        this.upperLimitScale = 512.0f;
        this.lowerLimitScale = 512.0f;
        BOPConfig.ConfigFileObj worldConfig = new BOPConfig.ConfigFileObj(new File(BiomesOPlenty.configDirectory, "world.json"));
        this.fromConfigObj(worldConfig);
    }

    @Override
    public boolean isEnabled(IBOPWorldSettings.GeneratorType type) {
        switch (type) {
            case GEMS: {
                return this.generateBopGems;
            }
            case POISON_IVY: {
                return this.generatePoisonIvy;
            }
            case BERRY_BUSHES: {
                return this.generateBerryBushes;
            }
            case THORNS: {
                return this.generateThorns;
            }
            case QUICKSAND: {
                return this.generateQuicksand;
            }
            case LIQUID_POISON: {
                return this.generateLiquidPoison;
            }
            case HOT_SPRINGS: {
                return this.generateHotSprings;
            }
            case NETHER_HIVES: {
                return this.generateNetherHives;
            }
            case END_FEATURES: {
                return this.generateEndFeatures;
            }
        }
        return true;
    }

    public static enum BiomeSize {
        TINY(2),
        SMALL(3),
        MEDIUM(4),
        LARGE(5),
        HUGE(6);

        private final int value;

        private BiomeSize(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum RainfallVariationScheme {
        SMALL_ZONES,
        MEDIUM_ZONES,
        LARGE_ZONES,
        RANDOM;

    }

    public static enum TemperatureVariationScheme {
        LATITUDE,
        SMALL_ZONES,
        MEDIUM_ZONES,
        LARGE_ZONES,
        RANDOM;

    }

    public static enum LandMassScheme {
        VANILLA,
        CONTINENTS,
        ARCHIPELAGO;

    }
}

