/*
 * Decompiled with CFR 0.152.
 */
package forestry.worktable.recipes;

import forestry.api.core.INbtReadable;
import forestry.api.core.INbtWritable;
import forestry.core.network.IStreamable;
import forestry.core.network.PacketBufferForestry;
import forestry.core.utils.InventoryUtil;
import forestry.core.utils.NBTUtilForestry;
import forestry.worktable.inventory.InventoryCraftingForestry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class MemorizedRecipe
implements INbtWritable,
INbtReadable,
IStreamable {
    private InventoryCraftingForestry craftMatrix = new InventoryCraftingForestry();
    private List<IRecipe> recipes = new ArrayList<IRecipe>();
    private int selectedRecipe;
    private long lastUsed;
    private boolean locked;

    public MemorizedRecipe(PacketBufferForestry data) throws IOException {
        this.readData(data);
    }

    public MemorizedRecipe(NBTTagCompound nbt) {
        this.readFromNBT(nbt);
    }

    public MemorizedRecipe(InventoryCraftingForestry craftMatrix, List<IRecipe> recipes) {
        InventoryUtil.deepCopyInventoryContents((IInventory)craftMatrix, (IInventory)this.craftMatrix);
        this.recipes = recipes;
    }

    public InventoryCraftingForestry getCraftMatrix() {
        return this.craftMatrix;
    }

    public void setCraftMatrix(InventoryCraftingForestry craftMatrix) {
        this.craftMatrix = craftMatrix;
    }

    public void incrementRecipe() {
        ++this.selectedRecipe;
        if (this.selectedRecipe >= this.recipes.size()) {
            this.selectedRecipe = 0;
        }
    }

    public void decrementRecipe() {
        --this.selectedRecipe;
        if (this.selectedRecipe < 0) {
            this.selectedRecipe = this.recipes.size() - 1;
        }
    }

    public boolean hasRecipeConflict() {
        return this.recipes.size() > 1;
    }

    public void removeRecipeConflicts() {
        IRecipe recipe = this.getSelectedRecipe();
        this.recipes.clear();
        this.recipes.add(recipe);
        this.selectedRecipe = 0;
    }

    public ItemStack getOutputIcon() {
        ItemStack recipeOutput;
        IRecipe selectedRecipe = this.getSelectedRecipe();
        if (selectedRecipe != null && !(recipeOutput = selectedRecipe.func_77572_b((InventoryCrafting)this.craftMatrix)).func_190926_b()) {
            return recipeOutput;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack getCraftingResult(InventoryCrafting inventoryCrafting, World world) {
        ItemStack recipeOutput;
        IRecipe selectedRecipe = this.getSelectedRecipe();
        if (selectedRecipe != null && selectedRecipe.func_77569_a(inventoryCrafting, world) && !(recipeOutput = selectedRecipe.func_77572_b(inventoryCrafting)).func_190926_b()) {
            return recipeOutput;
        }
        return ItemStack.field_190927_a;
    }

    @Nullable
    public IRecipe getSelectedRecipe() {
        if (this.recipes.isEmpty()) {
            return null;
        }
        return this.recipes.get(this.selectedRecipe);
    }

    public boolean hasRecipe(@Nullable IRecipe recipe) {
        return this.recipes.contains(recipe);
    }

    public void updateLastUse(long lastUsed) {
        this.lastUsed = lastUsed;
    }

    public long getLastUsed() {
        return this.lastUsed;
    }

    public void toggleLock() {
        this.locked = !this.locked;
    }

    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public final void readFromNBT(NBTTagCompound nbttagcompound) {
        InventoryUtil.readFromNBT((IInventory)this.craftMatrix, nbttagcompound);
        this.lastUsed = nbttagcompound.func_74763_f("LastUsed");
        this.locked = nbttagcompound.func_74767_n("Locked");
        if (nbttagcompound.func_74764_b("SelectedRecipe")) {
            this.selectedRecipe = nbttagcompound.func_74762_e("SelectedRecipe");
        }
        this.recipes.clear();
        NBTTagList recipesNbt = nbttagcompound.func_150295_c("Recipes", NBTUtilForestry.EnumNBTType.STRING.ordinal());
        for (int i = 0; i < recipesNbt.func_74745_c(); ++i) {
            String recipeKey = recipesNbt.func_150307_f(i);
            ResourceLocation key = new ResourceLocation(recipeKey);
            IRecipe recipe = (IRecipe)ForgeRegistries.RECIPES.getValue(key);
            if (recipe == null) continue;
            this.recipes.add(recipe);
        }
        if (this.selectedRecipe > this.recipes.size()) {
            this.selectedRecipe = 0;
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbttagcompound) {
        InventoryUtil.writeToNBT((IInventory)this.craftMatrix, nbttagcompound);
        nbttagcompound.func_74772_a("LastUsed", this.lastUsed);
        nbttagcompound.func_74757_a("Locked", this.locked);
        nbttagcompound.func_74768_a("SelectedRecipe", this.selectedRecipe);
        NBTTagList recipesNbt = new NBTTagList();
        for (IRecipe recipe : this.recipes) {
            ResourceLocation recipeKey = ForgeRegistries.RECIPES.getKey((IForgeRegistryEntry)recipe);
            if (recipeKey == null) continue;
            recipesNbt.func_74742_a((NBTBase)new NBTTagString(recipeKey.toString()));
        }
        nbttagcompound.func_74782_a("Recipes", (NBTBase)recipesNbt);
        return nbttagcompound;
    }

    @Override
    public void writeData(PacketBufferForestry data) {
        data.writeInventory((IInventory)this.craftMatrix);
        data.writeBoolean(this.locked);
        data.func_150787_b(this.selectedRecipe);
        data.func_150787_b(this.recipes.size());
        for (IRecipe recipe : this.recipes) {
            ResourceLocation recipeId = ForgeRegistries.RECIPES.getKey((IForgeRegistryEntry)recipe);
            if (recipeId == null) continue;
            data.func_180714_a(recipeId.toString());
        }
    }

    @Override
    public void readData(PacketBufferForestry data) throws IOException {
        data.readInventory((IInventory)this.craftMatrix);
        this.locked = data.readBoolean();
        this.selectedRecipe = data.func_150792_a();
        this.recipes.clear();
        int recipeCount = data.func_150792_a();
        for (int i = 0; i < recipeCount; ++i) {
            String recipeId = data.readString();
            IRecipe recipe = (IRecipe)ForgeRegistries.RECIPES.getValue(new ResourceLocation(recipeId));
            if (recipe == null) continue;
            this.recipes.add(recipe);
        }
    }
}

