/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.triggers;

import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import forestry.api.farming.IFarmInventory;
import forestry.core.triggers.Trigger;
import forestry.core.utils.InventoryUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.farming.multiblock.IFarmControllerInternal;
import forestry.farming.multiblock.MultiblockLogicFarm;
import forestry.farming.tiles.TileFarmHatch;
import java.util.stream.Stream;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class TriggerLowSoil
extends Trigger {
    private final int threshold;

    public TriggerLowSoil(int threshold) {
        super("lowSoil." + threshold, "lowSoil", "low_soil");
        this.threshold = threshold;
    }

    @Override
    public String getDescription() {
        return super.getDescription() + " < " + this.threshold;
    }

    @Override
    public int maxParameters() {
        return 1;
    }

    public boolean isTriggerActive(TileEntity tile, EnumFacing side, IStatementContainer source, IStatementParameter[] parameters) {
        IStatementParameter parameter = null;
        if (parameters.length > 0) {
            parameter = parameters[0];
        }
        if (!(tile instanceof TileFarmHatch)) {
            return false;
        }
        TileFarmHatch tileHatch = (TileFarmHatch)tile;
        IFarmControllerInternal farmController = ((MultiblockLogicFarm)tileHatch.getMultiblockLogic()).getController();
        IFarmInventory farmInventory = farmController.getFarmInventory();
        IInventory resourcesInventory = farmInventory.getResourcesInventory();
        Stream<ItemStack> stackStream = InventoryUtil.getStacks(resourcesInventory).stream();
        if (parameter != null && !parameter.getItemStack().func_190926_b()) {
            ItemStack filter = parameter.getItemStack();
            stackStream = stackStream.filter(s -> ItemStackUtil.areItemStacksEqualIgnoreCount(filter, s));
        }
        return stackStream.mapToInt(ItemStack::func_190916_E).sum() < this.threshold;
    }
}

