/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.blocks;

import forestry.core.blocks.IBlockTypeTesr;
import forestry.core.blocks.IMachinePropertiesTesr;
import forestry.core.blocks.MachinePropertiesTesr;
import forestry.core.proxy.Proxies;
import forestry.core.tiles.TileBase;
import forestry.core.tiles.TileEngine;
import forestry.energy.ModuleEnergy;
import forestry.energy.tiles.TileEngineBiogas;
import forestry.energy.tiles.TileEngineClockwork;
import forestry.energy.tiles.TileEngineElectric;
import forestry.energy.tiles.TileEnginePeat;
import forestry.energy.tiles.TileEuGenerator;

public enum BlockTypeEngine implements IBlockTypeTesr
{
    PEAT(BlockTypeEngine.createEngineProperties(TileEnginePeat.class, "peat", "/engine_copper")),
    BIOGAS(BlockTypeEngine.createEngineProperties(TileEngineBiogas.class, "biogas", "/engine_bronze")),
    CLOCKWORK(BlockTypeEngine.createEngineProperties(TileEngineClockwork.class, "clockwork", "/engine_clock")),
    ELECTRICAL(BlockTypeEngine.createEngineProperties(TileEngineElectric.class, "electrical", "/engine_tin")),
    GENERATOR(BlockTypeEngine.createMachineProperties(TileEuGenerator.class, "generator", "/generator"));

    public static final BlockTypeEngine[] VALUES;
    private final IMachinePropertiesTesr<?> machineProperties;

    private BlockTypeEngine(IMachinePropertiesTesr<?> machineProperties) {
        this.machineProperties = machineProperties;
    }

    protected static IMachinePropertiesTesr<?> createEngineProperties(Class<? extends TileEngine> teClass, String name, String textureName) {
        MachinePropertiesTesr<? extends TileEngine> machinePropertiesEngine = new MachinePropertiesTesr<TileEngine>(teClass, name, "forestry:blocks" + textureName + ".0", false);
        ModuleEnergy.proxy.setRenderDefaultEngine(machinePropertiesEngine, "textures/blocks" + textureName + "_");
        return machinePropertiesEngine;
    }

    protected static IMachinePropertiesTesr<?> createMachineProperties(Class<? extends TileBase> teClass, String name, String textureName) {
        MachinePropertiesTesr<? extends TileBase> machinePropertiesTesr = new MachinePropertiesTesr<TileBase>(teClass, name, "forestry:blocks" + textureName + ".0");
        Proxies.render.setRenderDefaultMachine(machinePropertiesTesr, "textures/blocks" + textureName + "_");
        return machinePropertiesTesr;
    }

    public IMachinePropertiesTesr<?> getMachineProperties() {
        return this.machineProperties;
    }

    public String func_176610_l() {
        return this.getMachineProperties().func_176610_l();
    }

    static {
        VALUES = BlockTypeEngine.values();
    }
}

