/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.items;

import forestry.core.items.ItemForestry;
import forestry.core.proxy.Proxies;
import forestry.core.utils.Log;
import forestry.core.utils.MigrationHelper;
import forestry.modules.InternalModuleHandler;
import forestry.modules.ModuleManager;
import java.util.Locale;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;

public abstract class ItemRegistry {
    protected static <T extends Item> T registerItem(T item, String name) {
        if (ModuleManager.getInternalHandler().getStage() != InternalModuleHandler.Stage.REGISTER) {
            throw new RuntimeException("Tried to register Item outside of REGISTER");
        }
        if (!name.equals(name.toLowerCase(Locale.ENGLISH))) {
            Log.error("Name must be lowercase", new Object[0]);
        }
        item.func_77655_b("for." + name);
        item.setRegistryName(name);
        MigrationHelper.addItemName(name);
        ForgeRegistries.ITEMS.register(item);
        Proxies.common.registerItem(item);
        return item;
    }

    protected static void registerOreDict(String oreDictName, ItemStack itemStack) {
        OreDictionary.registerOre((String)oreDictName, (ItemStack)itemStack);
    }

    public static ItemStack createItemForOreName(String oreName, String registryName) {
        ItemStack oreItem = new ItemStack((Item)ItemRegistry.registerItem(new ItemForestry(), registryName));
        OreDictionary.registerOre((String)oreName, (ItemStack)oreItem);
        return oreItem;
    }
}

