/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.elements;

import com.google.common.collect.ImmutableMap;
import forestry.api.gui.GuiElementAlignment;
import forestry.api.gui.ILabelElement;
import forestry.api.gui.style.ITextStyle;
import forestry.core.gui.elements.GuiElement;
import forestry.core.utils.GuiElementUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;

public class LabelElement
extends GuiElement
implements ILabelElement {
    public static final FontRenderer FONT_RENDERER = Minecraft.func_71410_x().field_71466_p;
    protected ITextStyle style;
    protected String text;
    protected String rawText;
    protected boolean textLength = false;

    public LabelElement(String text, GuiElementAlignment align, ITextStyle style) {
        this(0, 0, -1, LabelElement.FONT_RENDERER.field_78288_b, text, align, style);
    }

    public LabelElement(int xPos, int yPos, int width, int height, String text, GuiElementAlignment align, ITextStyle style) {
        super(xPos, yPos, width, height);
        this.textLength = width < 0;
        this.style = style;
        this.rawText = text;
        this.text = GuiElementUtil.getFormattedString(style, text);
        this.setAlign(align);
        if (this.textLength) {
            boolean uni = FONT_RENDERER.func_82883_a();
            FONT_RENDERER.func_78264_a(style.isUnicode());
            this.setWidth(FONT_RENDERER.func_78256_a(this.text));
            FONT_RENDERER.func_78264_a(uni);
        }
    }

    @Override
    public ILabelElement setStyle(ITextStyle style) {
        this.style = style;
        this.text = GuiElementUtil.getFormattedString(style, this.rawText);
        if (this.textLength) {
            boolean uni = FONT_RENDERER.func_82883_a();
            FONT_RENDERER.func_78264_a(style.isUnicode());
            this.setWidth(FONT_RENDERER.func_78256_a(this.text));
            FONT_RENDERER.func_78264_a(uni);
        }
        return this;
    }

    @Override
    public ITextStyle getStyle() {
        return this.style;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public ILabelElement setText(String text) {
        this.rawText = text;
        this.text = GuiElementUtil.getFormattedString(this.style, text);
        if (this.textLength) {
            boolean uni = FONT_RENDERER.func_82883_a();
            FONT_RENDERER.func_78264_a(this.style.isUnicode());
            this.setWidth(FONT_RENDERER.func_78256_a(this.text));
            FONT_RENDERER.func_78264_a(uni);
        }
        return this;
    }

    @Override
    public String getRawText() {
        return this.rawText;
    }

    @Override
    public Collection<String> getLines() {
        return Collections.singletonList(this.text);
    }

    @Override
    public Map<ITextStyle, String> getRawLines() {
        return ImmutableMap.of((Object)this.style, (Object)this.rawText);
    }

    @Override
    public void drawElement(int mouseX, int mouseY) {
        boolean unicode = FONT_RENDERER.func_82883_a();
        FONT_RENDERER.func_78264_a(this.style.isUnicode());
        FONT_RENDERER.func_78276_b(this.text, 0, 0, this.style.getColor());
        FONT_RENDERER.func_78264_a(unicode);
    }
}

