/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.TreeBlockTypeLeaf;
import forestry.arboriculture.worldgen.TreeBlockTypeLog;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.worldgen.WorldGenHelper;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldGenWalnut
extends WorldGenTree {
    public WorldGenWalnut(ITreeGenData tree) {
        super(tree, 7, 3);
    }

    @Override
    public Set<BlockPos> generateTrunk(World world, Random rand, TreeBlockTypeLog wood, BlockPos startPos) {
        WorldGenHelper.generateTreeTrunk(world, rand, wood, startPos, this.height, this.girth, 0, 0.0f, null, 0.0f);
        HashSet<BlockPos> branchEnds = new HashSet<BlockPos>();
        int branchHeight = this.height - 3;
        float branchSize = 2.0f;
        while (branchHeight >= 3) {
            branchEnds.addAll(WorldGenHelper.generateBranches(world, rand, wood, startPos.func_177982_a(0, branchHeight, 0), this.girth, 0.2f, 0.2f, (int)branchSize, 1, 0.5f));
            --branchHeight;
            branchSize += 0.25f;
        }
        return branchEnds;
    }

    @Override
    protected void generateLeaves(World world, Random rand, TreeBlockTypeLeaf leaf, List<BlockPos> branchEnds, BlockPos startPos) {
        int leafSpawn = this.height + 1;
        WorldGenHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, this.girth, 1, WorldGenHelper.EnumReplaceMode.SOFT);
        WorldGenHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, 0.5f + (float)this.girth, 1, WorldGenHelper.EnumReplaceMode.SOFT);
        WorldGenHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, 1.5f + (float)this.girth, 1, WorldGenHelper.EnumReplaceMode.SOFT);
        WorldGenHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, 2.0f + (float)this.girth, 1, WorldGenHelper.EnumReplaceMode.SOFT);
        float branchSize = 2.0f;
        while (leafSpawn >= 3) {
            int leafRadius = Math.min(4, (int)branchSize);
            for (BlockPos branchEnd : branchEnds) {
                WorldGenHelper.generateCircle(world, rand, branchEnd, leafRadius, 2, 2, leaf, 1.0f, WorldGenHelper.EnumReplaceMode.SOFT);
            }
            --leafSpawn;
            branchSize += 0.25f;
        }
    }
}

