/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.energyconverters.common;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="energyconverters")
@Config(modid="energyconverters")
public class EnergyConvertersConfig {
    @Config.Comment(value={"Maximum amount of energy the bridge can buffer. This needs to be >0 otherwise, the bridge is not able to convert energy"})
    @Config.Name(value="energyBridgeBuffer")
    @Config.RangeInt(min=0)
    public static double bridgeEnergyBuffer = 10000.0;
    @Config.Comment(value={"EU (IndustrialCraft2) to Energy Converters internal energy conversion factor. 1 EU is converted into this amount of Energy Converters Energy"})
    @Config.Name(value="euConversionFactor")
    @Config.RangeDouble(min=0.001)
    public static double ic2Conversion = 4.0;
    @Config.Comment(value={"RF (RedstoneFlux) to Energy Converters internal energy conversion factor. 1 RF is converted into this amount of Energy Converters Energy"})
    @Config.Name(value="rfConversionFactor")
    @Config.RangeDouble(min=0.001)
    public static double rfConversion = 1.0;
    @Config.Comment(value={"FE (ForgeEnergy) to Energy Converters internal energy conversion factor. 1 FE is converted into this amount of Energy Converters Energy"})
    @Config.Name(value="feConversionFactor")
    @Config.RangeDouble(min=0.001)
    public static double feConversion = 1.0;
    @Config.Comment(value={"MJ (Buildcraft) to Energy Converters internal energy conversion factor. 1 MJ is converted into this amount of Energy Converters Energy"})
    @Config.Name(value="mjConversionFactor")
    @Config.RangeDouble(min=0.001)
    public static double mjConversion = 15.0;
    @Config.Comment(value={"Tesla to Energy Converters internal energy conversion factor. 1 Tesla is converted into this amount of Energy Converters Energy"})
    @Config.Name(value="teslaConversionFactor")
    @Config.RangeDouble(min=0.001)
    public static double teslaConversion = 1.0;
    @Config.Comment(value={"Percentage of energy lost on conversion."})
    @Config.Name(value="conversionLoss")
    @Config.RangeDouble(min=0.0, max=100.0)
    public static double conversionLoss = 0.0;
    @Config.Comment(value={"Controls if hints should be shown in the tooltip for certain problematic converter blocks. To modpack makers: Do not disable this without providing alternative hints."})
    @Config.Name(value="showInfoTooltips")
    public static boolean showInfoTooltips = true;

    @Mod.EventBusSubscriber
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if ("energyconverters".equals(event.getModID())) {
                ConfigManager.sync((String)"energyconverters", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }
}

