/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.inventory;

import com.google.common.base.Preconditions;
import net.malisis.core.inventory.InventoryState;
import net.malisis.core.inventory.MalisisInventory;
import net.malisis.core.util.ItemUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class MalisisSlot {
    protected MalisisInventory inventory;
    protected ItemStack itemStack = ItemStack.field_190927_a;
    protected ItemStack draggedItemStack = ItemStack.field_190927_a;
    protected int index;
    protected InventoryState state = new InventoryState();

    public MalisisSlot(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    public MalisisSlot() {
        this(ItemStack.field_190927_a);
    }

    protected void setup(MalisisInventory inventory, int slotIndex) {
        this.inventory = inventory;
        this.index = slotIndex;
    }

    public void register(Object object) {
        if (this.inventory != null) {
            this.inventory.register(object);
        }
    }

    public MalisisInventory getInventory() {
        return this.inventory;
    }

    public int getSlotIndex() {
        return this.index;
    }

    public int getInventoryId() {
        return this.inventory.getInventoryId();
    }

    public void setItemStack(ItemStack itemStack) {
        this.itemStack = (ItemStack)Preconditions.checkNotNull((Object)itemStack);
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public void setDraggedItemStack(ItemStack itemStack) {
        this.draggedItemStack = (ItemStack)Preconditions.checkNotNull((Object)itemStack);
    }

    public ItemStack getDraggedItemStack() {
        return this.draggedItemStack;
    }

    public void setOutputSlot() {
        this.state.unset(InventoryState.PLAYER_INSERT | InventoryState.AUTO_INSERT);
    }

    public boolean isOutputSlot() {
        return !this.state.is(InventoryState.PLAYER_INSERT) && !this.state.is(InventoryState.AUTO_INSERT);
    }

    public boolean isState(int state) {
        return this.inventory.state.is(state) && this.state.is(state);
    }

    public boolean isItemValid(ItemStack itemStack) {
        if (this.inventory == null) {
            return true;
        }
        return this.inventory.itemValidForSlot(this, itemStack);
    }

    public boolean isFull() {
        return !this.itemStack.func_190926_b() && this.itemStack.func_190916_E() == Math.min(this.itemStack.func_77976_d(), this.getSlotStackLimit());
    }

    public boolean isNotFull() {
        return this.itemStack.func_190926_b() || this.itemStack.func_190916_E() < Math.min(this.itemStack.func_77976_d(), this.getSlotStackLimit());
    }

    public boolean isEmpty() {
        return this.itemStack.func_190926_b();
    }

    public boolean isNotEmpty() {
        return !this.itemStack.func_190926_b();
    }

    public void onSlotChanged() {
        this.inventory.onSlotChanged(this);
    }

    public void onPickupFromSlot(EntityPlayer player, ItemStack itemStack) {
        this.onSlotChanged();
    }

    public int setItemStackSize(int stackSize) {
        if (this.itemStack.func_190926_b()) {
            return 0;
        }
        int start = this.itemStack.func_190916_E();
        this.itemStack.func_190920_e(Math.min(stackSize, Math.min(this.itemStack.func_77976_d(), this.getSlotStackLimit())));
        return this.itemStack.func_190916_E() - start;
    }

    public int addItemStackSize(int stackSize) {
        if (this.itemStack.func_190926_b()) {
            return 0;
        }
        return this.setItemStackSize(this.itemStack.func_190916_E() + stackSize);
    }

    public ItemStack extract() {
        if (this.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        ItemStack is = this.getItemStack();
        this.setItemStack(ItemStack.field_190927_a);
        this.onSlotChanged();
        return is;
    }

    public ItemStack extract(int amount) {
        ItemUtils.ItemStackSplitter iss = new ItemUtils.ItemStackSplitter(this.getItemStack());
        iss.split(amount);
        this.setItemStack(iss.source);
        this.onSlotChanged();
        return iss.split;
    }

    public boolean extractInto(ItemStack itemStack) {
        ItemUtils.ItemStacksMerger ism = new ItemUtils.ItemStacksMerger(this.getItemStack(), itemStack);
        if (!ism.merge()) {
            return false;
        }
        if (ism.nbMerged != 0) {
            this.setItemStack(ism.merge);
            this.onSlotChanged();
        }
        return itemStack.func_190916_E() >= itemStack.func_77976_d();
    }

    public ItemStack insert(ItemStack insert) {
        return this.insert(insert, insert.func_190916_E(), false);
    }

    public ItemStack insert(ItemStack insert, int amount) {
        return this.insert(insert, amount, false);
    }

    public ItemStack insert(ItemStack insert, int amount, boolean force) {
        if (insert.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (!this.isItemValid(insert)) {
            return insert;
        }
        ItemUtils.ItemStacksMerger ism = new ItemUtils.ItemStacksMerger(insert, this.itemStack);
        if (!ism.canMerge() || this.isFull()) {
            if (!force) {
                return insert;
            }
            ItemStack slotStack = this.extract(-1);
            ItemStack insertStack = insert.func_77946_l();
            if (this.insert(insertStack, amount, false).func_190926_b()) {
                this.setItemStack(insert);
                return slotStack;
            }
            return slotStack;
        }
        ism.merge(amount, this.getSlotStackLimit());
        this.setItemStack(ism.into);
        this.onSlotChanged();
        return ism.merge;
    }

    public int getSlotStackLimit() {
        if (this.inventory == null) {
            return 64;
        }
        return this.inventory.getInventoryStackLimit();
    }

    public String toString() {
        String str = this.index + (this.inventory != null ? "/" + this.inventory.getSize() : "") + " > " + ItemUtils.toString(this.itemStack);
        if (!this.draggedItemStack.func_190926_b()) {
            str = str + " (D: " + ItemUtils.toString(this.draggedItemStack) + ")";
        }
        return str;
    }
}

