/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component.interaction;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.malisis.core.client.gui.BasicScreen;
import net.malisis.core.client.gui.UIConstants;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.component.container.BasicContainer;
import net.malisis.core.client.gui.component.container.BasicForm;
import net.malisis.core.client.gui.component.interaction.UITextField;
import net.malisis.core.client.gui.event.ComponentEvent;

public class BasicTextBox
extends UITextField {
    @Nullable
    private Consumer<BasicTextBox> onEnter;
    private boolean acceptsTab = true;
    private boolean acceptsReturn = true;
    private int tabIndex = 0;

    public BasicTextBox(BasicScreen screen) {
        this(screen, "", false);
    }

    public BasicTextBox(BasicScreen screen, String text) {
        this(screen, text, false);
    }

    public BasicTextBox(BasicScreen screen, boolean multiLine) {
        this(screen, "", multiLine);
    }

    public BasicTextBox(BasicScreen screen, String text, boolean multiLine) {
        super(screen, text, multiLine);
        this.setFontOptions(UIConstants.DEFAULT_TEXTBOX_FO);
    }

    @Override
    public boolean onKeyTyped(char keyChar, int keyCode) {
        if (!(keyCode != 28 || this.multiLine && this.acceptsReturn)) {
            if (this.onEnter != null) {
                this.onEnter.accept(this);
            }
            return false;
        }
        if (keyCode == 1) {
            this.closeDeep(this);
            return false;
        }
        if (keyCode == 15 && !this.acceptsTab && this.parent instanceof BasicContainer) {
            if (BasicScreen.func_146272_n()) {
                ((BasicContainer)this.parent).tabToLastControl();
            } else {
                ((BasicContainer)this.parent).tabToNextControl();
            }
            return false;
        }
        return super.onKeyTyped(keyChar, keyCode);
    }

    @Override
    public UITextField setEditable(boolean editable) {
        this.setFontOptions(editable ? UIConstants.DEFAULT_TEXTBOX_FO : UIConstants.READ_ONLY_TEXTBOX_FO);
        return super.setEditable(editable);
    }

    public BasicTextBox focus() {
        if (!this.isEnabled()) {
            return this;
        }
        this.setFocused(true);
        ((BasicScreen)this.getGui()).setFocusedComponent(this);
        return this;
    }

    public BasicTextBox selectAll() {
        this.selectingText = true;
        this.selectionPosition.jumpToBeginning();
        this.cursorPosition.jumpToEnd();
        return this;
    }

    public BasicTextBox deselectAll() {
        this.selectingText = false;
        this.selectionPosition.jumpTo(0);
        this.cursorPosition.jumpTo(this.text.length());
        return this;
    }

    public void wrap(String prefix, String suffix) {
        if (this.getSelectedText().isEmpty()) {
            return;
        }
        StringBuilder oldText = this.text;
        String oldValue = this.text.toString();
        boolean cursorIsStart = this.cursorPosition.getPosition() < this.selectionPosition.getPosition();
        UITextField.CursorPosition start = cursorIsStart ? this.cursorPosition : this.selectionPosition;
        UITextField.CursorPosition end = start == this.cursorPosition ? this.selectionPosition : this.cursorPosition;
        String newValue = oldText.insert(start.getPosition(), prefix).insert(end.getPosition() + prefix.length(), suffix).toString();
        if (this.filterFunction != null) {
            newValue = (String)this.filterFunction.apply(newValue);
        }
        if (!this.fireEvent(new ComponentEvent.ValueChange<BasicTextBox, String>(this, oldValue, newValue))) {
            return;
        }
        this.text = new StringBuilder(newValue);
        this.buildLines();
        int jumpLength = cursorIsStart ? suffix.length() : prefix.length();
        this.cursorPosition.jumpBy(jumpLength);
        this.selectionPosition.jumpBy(jumpLength);
    }

    public boolean getAcceptsReturn() {
        return this.acceptsReturn;
    }

    public BasicTextBox setAcceptsReturn(boolean acceptsReturn) {
        this.acceptsReturn = acceptsReturn;
        return this;
    }

    public boolean getAcceptsTab() {
        return this.acceptsTab;
    }

    public BasicTextBox setAcceptsTab(boolean acceptsTab) {
        this.acceptsTab = acceptsTab;
        return this;
    }

    public int getTabIndex() {
        return this.tabIndex;
    }

    public BasicTextBox setTabIndex(int tabIndex) {
        this.tabIndex = tabIndex;
        return this;
    }

    public BasicTextBox setOnEnter(Consumer<BasicTextBox> onEnter) {
        this.onEnter = onEnter;
        return this;
    }

    private void closeDeep(UIComponent component) {
        if (component.getParent() instanceof BasicForm) {
            ((BasicForm)component.getParent()).onClose();
            return;
        }
        if (component.getParent() != null) {
            this.closeDeep(component.getParent());
        }
    }
}

