/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock;

import javax.annotation.Nonnull;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;

public enum RotorShaftState implements IStringSerializable
{
    HIDDEN,
    Y_NOBLADES,
    Y_X,
    Y_Z,
    Y_XZ,
    X_NOBLADES,
    X_Y,
    X_Z,
    X_YZ,
    Z_NOBLADES,
    Z_Y,
    Z_X,
    Z_XY;

    public static final EnumFacing[] BLADES_DIRECTIONS_X;
    public static final EnumFacing[] BLADES_DIRECTIONS_Y;
    public static final EnumFacing[] BLADES_DIRECTIONS_Z;
    private final String _name = this.name().toLowerCase();

    public String toString() {
        return this._name;
    }

    public String func_176610_l() {
        return this._name;
    }

    @Nonnull
    public static RotorShaftState from(@Nonnull EnumFacing.Axis shaftAxis) {
        RotorShaftState state;
        switch (shaftAxis) {
            default: {
                state = Y_NOBLADES;
                break;
            }
            case X: {
                state = X_NOBLADES;
                break;
            }
            case Z: {
                state = Z_NOBLADES;
            }
        }
        return state;
    }

    @Nonnull
    public static RotorShaftState from(@Nonnull EnumFacing.Axis shaftAxis, @Nonnull boolean[] directionsWithBlades) {
        RotorShaftState state;
        EnumFacing[] directions = RotorShaftState.getBladesDirections(shaftAxis);
        EnumFacing.Axis[] bladesAxis = new EnumFacing.Axis[2];
        for (int i = 0; i < 2; ++i) {
            if (!directionsWithBlades[i] || !directionsWithBlades[i + 2]) continue;
            bladesAxis[i] = directions[i].func_176740_k();
        }
        switch (shaftAxis) {
            default: {
                state = Y_NOBLADES;
                break;
            }
            case X: {
                state = X_NOBLADES;
                break;
            }
            case Z: {
                state = Z_NOBLADES;
            }
        }
        return state;
    }

    public static EnumFacing[] getBladesDirections(EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return BLADES_DIRECTIONS_X;
            }
            default: {
                return BLADES_DIRECTIONS_Y;
            }
            case Z: 
        }
        return BLADES_DIRECTIONS_Z;
    }

    static {
        BLADES_DIRECTIONS_X = new EnumFacing[]{EnumFacing.UP, EnumFacing.NORTH, EnumFacing.DOWN, EnumFacing.SOUTH};
        BLADES_DIRECTIONS_Y = new EnumFacing[]{EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.WEST};
        BLADES_DIRECTIONS_Z = new EnumFacing[]{EnumFacing.UP, EnumFacing.EAST, EnumFacing.DOWN, EnumFacing.WEST};
    }
}

