/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.collectiveframework.minecraft.books.simple;

import com.austinv11.collectiveframework.minecraft.books.api.Entry;
import com.austinv11.collectiveframework.utils.math.TwoDimensionalVector;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TextEntry
extends Entry {
    public boolean useUnicodeFont = true;
    public boolean useFontShadow = true;
    public Alignment alignment = Alignment.LEFT;
    private String toRender;
    @SideOnly(value=Side.CLIENT)
    private FontRenderer renderer;

    public TextEntry(TwoDimensionalVector coords, int width, int height, String toRender) {
        this(coords, width, height);
        this.toRender = toRender;
    }

    private TextEntry(TwoDimensionalVector coords, int width, int height) {
        super(coords, width, height);
        this.renderer = Minecraft.func_71410_x().field_71466_p;
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> fitString() {
        String[] lines;
        ArrayList<String> strings = new ArrayList<String>();
        for (String line : lines = this.toRender.split("\n")) {
            String[] split;
            String currentString = "";
            for (String s : split = line.split(" ")) {
                if (this.renderer.func_78256_a(currentString + " " + s) > this.field_146294_l) {
                    strings.add(currentString);
                    currentString = s;
                    continue;
                }
                currentString = currentString + " " + s;
            }
            strings.add(currentString);
        }
        return strings;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRender(int dt) {
        List<String> lines = this.fitString();
        boolean unicode = this.renderer.func_82883_a();
        this.renderer.func_78264_a(this.useUnicodeFont);
        int currentY = this.getCoords().getRoundedY();
        if (this.alignment == Alignment.LEFT) {
            for (String s : lines) {
                this.renderer.func_175065_a(s, (float)this.getCoords().getRoundedX(), (float)currentY, Color.WHITE.getRGB(), this.useFontShadow);
                if ((currentY += this.renderer.field_78288_b) < this.getCoords().getRoundedY() + this.field_146295_m) continue;
                break;
            }
        } else if (this.alignment == Alignment.CENTER) {
            for (String s : lines) {
                this.renderer.func_175065_a(s, (float)(this.getCoords().getRoundedX() + (this.field_146294_l - this.renderer.func_78256_a(s)) / 2), (float)currentY, Color.WHITE.getRGB(), this.useFontShadow);
                if ((currentY += this.renderer.field_78288_b) < this.getCoords().getRoundedY() + this.field_146295_m) continue;
                break;
            }
        } else if (this.alignment == Alignment.RIGHT) {
            for (String s : lines) {
                this.renderer.func_175065_a(s, (float)(this.getCoords().getRoundedX() + (this.field_146294_l - this.renderer.func_78256_a(s))), (float)currentY, Color.WHITE.getRGB(), this.useFontShadow);
                if ((currentY += this.renderer.field_78288_b) < this.getCoords().getRoundedY() + this.field_146295_m) continue;
                break;
            }
        } else {
            for (String s : lines) {
                int i;
                int spacesToAdd = (this.field_146294_l - this.renderer.func_78256_a(s)) / this.renderer.func_78263_a(' ');
                String[] words = s.split(" ");
                spacesToAdd += words.length;
                String justified = "";
                block4: while (spacesToAdd > 0) {
                    for (i = 0; i < words.length; ++i) {
                        if (spacesToAdd == 0) break block4;
                        words[i] = words[i] + " ";
                        --spacesToAdd;
                    }
                }
                for (i = 0; i < words.length; ++i) {
                    justified = justified + words[i];
                }
                this.renderer.func_175065_a(justified, (float)this.getCoords().getRoundedX(), (float)currentY, Color.WHITE.getRGB(), this.useFontShadow);
                if ((currentY += this.renderer.field_78288_b) < this.getCoords().getRoundedY() + this.field_146295_m) continue;
                break;
            }
        }
        this.renderer.func_78264_a(unicode);
    }

    public static enum Alignment {
        LEFT,
        CENTER,
        RIGHT,
        JUSTIFY;

    }
}

