/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.collectiveframework.language;

import com.austinv11.collectiveframework.language.translation.ITranslationProvider;
import com.austinv11.collectiveframework.language.translation.QueryLimitException;
import com.austinv11.collectiveframework.language.translation.TranslationException;
import com.austinv11.collectiveframework.language.translation.YandexProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TranslationManager {
    private static final List<ITranslationProvider> translators = new ArrayList<ITranslationProvider>();
    private static final List<String> unusableProviders = new ArrayList<String>();
    private static final HashMap<String, String> translationCache = new HashMap();

    public static void registerTranslationProvider(ITranslationProvider provider) {
        translators.add(provider);
    }

    public static String translate(String text, String toLang) throws TranslationException, IOException {
        if (translationCache.containsKey(text)) {
            return translationCache.get(text);
        }
        int i = 0;
        while (unusableProviders.contains(translators.get(i).getProviderName()) || !translators.get(i).canDetectLanguage()) {
            if (translators.contains(++i)) continue;
            throw new TranslationException(TranslationException.ErrorTypes.NO_VALID_PROVIDERS);
        }
        ITranslationProvider provider = translators.get(i);
        try {
            String translation = provider.translate(text, toLang);
            translationCache.put(text, translation);
            return translation;
        }
        catch (QueryLimitException e) {
            unusableProviders.add(provider.getProviderName());
            return TranslationManager.translate(text, toLang);
        }
    }

    public static String translate(String text, String fromLang, String toLang) throws TranslationException, IOException {
        if (translationCache.containsKey(text)) {
            return translationCache.get(text);
        }
        int i = 0;
        while (unusableProviders.contains(translators.get(i).getProviderName())) {
            if (translators.contains(++i)) continue;
            throw new TranslationException(TranslationException.ErrorTypes.NO_VALID_PROVIDERS);
        }
        ITranslationProvider provider = translators.get(i);
        try {
            String translation = provider.translate(text, fromLang, toLang);
            translationCache.put(text, translation);
            return translation;
        }
        catch (QueryLimitException e) {
            unusableProviders.add(provider.getProviderName());
            return TranslationManager.translate(text, fromLang, toLang);
        }
    }

    public static String detectLanguage(String text) throws TranslationException, IOException {
        int i = 0;
        while (unusableProviders.contains(translators.get(i).getProviderName())) {
            if (translators.contains(++i)) continue;
            throw new TranslationException(TranslationException.ErrorTypes.NO_VALID_PROVIDERS);
        }
        ITranslationProvider provider = translators.get(i);
        try {
            return provider.detectLangauge(text);
        }
        catch (QueryLimitException e) {
            unusableProviders.add(provider.getProviderName());
            return TranslationManager.detectLanguage(text);
        }
    }

    static {
        TranslationManager.registerTranslationProvider(new YandexProvider());
    }
}

