/*
 * Decompiled with CFR 0.152.
 */
package wanion.lib.recipe.advanced;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import wanion.lib.recipe.advanced.IAdvancedRecipe;

public abstract class AbstractRecipeRegistry<R extends IAdvancedRecipe> {
    public final Short2ObjectMap<List<R>> recipes = new Short2ObjectOpenHashMap();

    public final void addRecipe(@Nonnull R recipe) {
        short recipeKey = recipe.getRecipeKey();
        if (recipeKey == 0) {
            return;
        }
        if (!this.recipes.containsKey(recipeKey)) {
            this.recipes.put(recipeKey, new ArrayList());
        }
        ((List)this.recipes.get(recipeKey)).add(recipe);
    }

    public final void removeRecipe(@Nullable R recipe) {
        if (recipe == null) {
            return;
        }
        short recipeKey = recipe.getRecipeKey();
        if (recipeKey == 0) {
            return;
        }
        List recipeList = (List)this.recipes.get(recipeKey);
        if (recipeList != null) {
            recipeList.remove(recipe);
        }
    }

    @Nullable
    public final R findRecipeByKeyAndOutput(short key, @Nonnull ItemStack output) {
        List recipeList = (List)this.recipes.get(key);
        if (recipeList == null) {
            return null;
        }
        for (IAdvancedRecipe recipe : recipeList) {
            if (!recipe.getOutput().func_77969_a(output)) continue;
            return (R)recipe;
        }
        return null;
    }

    @Nullable
    public final R findMatchingRecipe(@Nonnull InventoryCrafting inventoryCrafting) {
        List recipeList;
        int x;
        int y;
        int root = (int)Math.sqrt(inventoryCrafting.func_70302_i_());
        int offSetX = 0;
        int offSetY = 0;
        int width = 0;
        int height = 0;
        short recipeKey = 0;
        short recipeSize = 0;
        boolean foundX = false;
        boolean foundY = false;
        for (int x2 = 0; !foundX && x2 < root; ++x2) {
            for (int y2 = 0; !foundX && y2 < root; ++y2) {
                if (inventoryCrafting.func_70301_a(y2 * root + x2).func_190926_b()) continue;
                foundX = true;
            }
            if (!foundX) continue;
            offSetX = x2;
        }
        for (y = 0; !foundY && y < root; ++y) {
            for (x = 0; x < root; ++x) {
                if (!inventoryCrafting.func_70301_a(y * root + x).func_190926_b()) {
                    foundY = true;
                }
                if (!foundY) continue;
                offSetY = y;
            }
        }
        for (y = 0; y < root; ++y) {
            int actualX;
            int actualY;
            x = 0;
            while ((actualY = offSetY + y) < root && (actualX = offSetX + x++) < root) {
                if (inventoryCrafting.func_70301_a(actualY * root + actualX).func_190926_b()) continue;
                int xDifference = actualX - (offSetX - 1);
                int yDifference = actualY - (offSetY - 1);
                if (xDifference > width) {
                    width = xDifference;
                }
                if (yDifference <= height) continue;
                height = yDifference;
            }
        }
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                if (inventoryCrafting.func_70301_a((offSetY + y) * root + (offSetX + x)).func_190926_b()) continue;
                recipeSize = (short)(recipeSize + 1);
            }
        }
        short s = (short)(recipeKey | (recipeSize | width << 8 | height << 12));
        recipeKey = s;
        List list = recipeList = this.recipes.containsKey(s) ? (List)this.recipes.get(recipeKey) : (List)this.recipes.get(recipeSize);
        if (recipeList != null) {
            for (IAdvancedRecipe recipe : recipeList) {
                if (!recipe.recipeMatches(inventoryCrafting, offSetX, offSetY)) continue;
                return (R)recipe;
            }
        }
        return null;
    }

    @Nonnull
    public final List<R> getAllRecipes() {
        ArrayList allTheRecipes = new ArrayList();
        for (List subRecipeList : this.recipes.values()) {
            if (subRecipeList == null) continue;
            allTheRecipes.addAll(subRecipeList);
        }
        return ImmutableList.copyOf(allTheRecipes);
    }
}

