/*
 * Decompiled with CFR 0.152.
 */
package wanion.lib.common.control.redstone;

import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.MathHelper;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import wanion.lib.common.control.IControlNameable;
import wanion.lib.common.control.IState;
import wanion.lib.common.control.IStateNameable;
import wanion.lib.common.control.IStateProvider;

public final class RedstoneControl
implements IStateProvider<RedstoneControl, RedstoneState>,
IControlNameable {
    private final TileEntity tileEntity;
    private RedstoneState state = RedstoneState.IGNORED;

    public RedstoneControl(@Nonnull TileEntity tileEntity) {
        this.tileEntity = tileEntity;
    }

    public RedstoneControl(@Nonnull TileEntity tileEntity, @Nonnull RedstoneState state) {
        this.tileEntity = tileEntity;
        this.state = state;
    }

    @Override
    public boolean canOperate() {
        if (this.state == RedstoneState.IGNORED) {
            return true;
        }
        boolean powered = this.tileEntity.func_145831_w().func_175640_z(this.tileEntity.func_174877_v());
        return this.state == RedstoneState.OFF && !powered || this.state == RedstoneState.ON && powered;
    }

    @Override
    public void writeToNBT(@Nonnull NBTTagCompound nbtTagCompound) {
        nbtTagCompound.func_74768_a("RedstoneControl", this.state.ordinal());
    }

    @Override
    public void readFromNBT(@Nonnull NBTTagCompound nbtTagCompound) {
        if (nbtTagCompound.func_74764_b("RedstoneControl")) {
            this.state = RedstoneState.values()[MathHelper.func_76125_a((int)nbtTagCompound.func_74762_e("RedstoneControl"), (int)0, (int)(RedstoneState.values().length - 1))];
        }
    }

    @Override
    @Nonnull
    public RedstoneControl copy() {
        return new RedstoneControl(this.tileEntity, this.state);
    }

    @Override
    @Nonnull
    public String getControlName() {
        return "wanionlib.redstone.control";
    }

    @Override
    public RedstoneState getState() {
        return this.state;
    }

    @Override
    public void setState(@Nonnull RedstoneState state) {
        this.state = state;
    }

    @Override
    public void writeToNBT(@Nonnull NBTTagCompound nbtTagCompound, @Nonnull RedstoneState state) {
        nbtTagCompound.func_74768_a("RedstoneControl", state.ordinal());
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof RedstoneControl && this.state == ((RedstoneControl)obj).state;
    }

    public static enum RedstoneState implements IState<RedstoneState>,
    IStateNameable
    {
        IGNORED,
        OFF,
        ON;


        @Override
        @Nonnull
        public RedstoneState getNextState() {
            int nextState = this.ordinal() + 1;
            return nextState > RedstoneState.values().length - 1 ? RedstoneState.values()[0] : RedstoneState.values()[nextState];
        }

        @Override
        @Nonnull
        public RedstoneState getPreviousState() {
            int previousState = this.ordinal() - 1;
            return previousState >= 0 ? RedstoneState.values()[previousState] : RedstoneState.values()[RedstoneState.values().length - 1];
        }

        @Override
        public Pair<Integer, Integer> getTexturePos(boolean hovered) {
            return new ImmutablePair((Object)(!hovered ? 0 : 18), (Object)(54 + 18 * this.ordinal()));
        }

        @Override
        @Nonnull
        public String getStateName() {
            return "wanionlib.redstone.control.state." + this.name().toLowerCase();
        }
    }
}

