/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.util.stackable;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import com.enderio.core.common.util.stackable.BlockThing;
import com.enderio.core.common.util.stackable.ExclusionThing;
import com.enderio.core.common.util.stackable.IThing;
import com.enderio.core.common.util.stackable.ItemStackThing;
import com.enderio.core.common.util.stackable.ItemThing;
import com.enderio.core.common.util.stackable.OreThing;
import com.enderio.core.common.util.stackable.Things;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

class StringThing
implements IThing {
    @Nonnull
    private final String name;

    StringThing(@Nullable String name) {
        this.name = name != null ? NullHelper.notnullJ(name.trim(), "String.trim()") : "";
    }

    @Override
    @Nonnull
    public NNList<IThing> bake() {
        if (this.name.isEmpty()) {
            return NNList.emptyList();
        }
        if (Things.aliases.containsKey(this.name)) {
            return Things.aliases.get(this.name).bake();
        }
        if (this.name.contains(",") || this.name.startsWith("+") || this.name.startsWith("-")) {
            return this.compound();
        }
        String mod = "minecraft";
        String ident = this.name;
        boolean allowItem = true;
        boolean allowBlock = true;
        boolean allowOreDict = true;
        if (ident.startsWith("item:")) {
            allowOreDict = false;
            allowBlock = false;
            ident = NullHelper.notnullJ(ident.substring("item:".length()), "String.substring()");
        } else if (ident.startsWith("block:")) {
            allowOreDict = false;
            allowItem = false;
            ident = NullHelper.notnullJ(ident.substring("block:".length()), "String.substring()");
        } else if (ident.startsWith("oredict:")) {
            allowItem = false;
            allowBlock = false;
            ident = NullHelper.notnullJ(ident.substring("oredict:".length()), "String.substring()");
        }
        int meta = -1;
        if (ident.contains(":")) {
            allowOreDict = false;
            String[] split = ident.split(":", 3);
            if (split != null && split.length >= 2) {
                if (split[0] != null && !split[0].trim().isEmpty()) {
                    mod = NullHelper.notnullJ(split[0], "variable lost its value from one moment to the next");
                }
                ident = split[1] != null && !split[1].trim().isEmpty() ? NullHelper.notnullJ(split[1], "variable lost its value from one moment to the next") : "null";
                if (split.length >= 3) {
                    if ("*".equals(split[2])) {
                        meta = Short.MAX_VALUE;
                    } else {
                        try {
                            meta = Integer.parseInt(split[2]);
                        }
                        catch (NumberFormatException e) {
                            return NNList.emptyList();
                        }
                    }
                }
            }
        }
        ResourceLocation resourceLocation = new ResourceLocation(mod, ident);
        if (meta < 0) {
            Item item;
            if (allowBlock && Block.field_149771_c.func_148741_d((Object)resourceLocation)) {
                Block block = (Block)Block.field_149771_c.func_82594_a((Object)resourceLocation);
                return new BlockThing(block).bake();
            }
            if (allowItem && Item.field_150901_e.func_148741_d((Object)resourceLocation) && (item = (Item)Item.field_150901_e.func_82594_a((Object)resourceLocation)) != null) {
                return new ItemThing(item).bake();
            }
            if (allowOreDict) {
                return new OreThing(ident).bake();
            }
        } else {
            Item item;
            if (allowItem && Item.field_150901_e.func_148741_d((Object)resourceLocation) && (item = (Item)Item.field_150901_e.func_82594_a((Object)resourceLocation)) != null) {
                return new ItemStackThing(new ItemStack(item, 1, meta)).bake();
            }
            if (allowBlock && Block.field_149771_c.func_148741_d((Object)resourceLocation)) {
                Block block = (Block)Block.field_149771_c.func_82594_a((Object)resourceLocation);
                return new ItemStackThing(new ItemStack(block, 1, meta)).bake();
            }
        }
        return NNList.emptyList();
    }

    @Nonnull
    private NNList<IThing> compound() {
        NNList<IThing> positive = new NNList<IThing>();
        NNList<IThing> negative = new NNList<IThing>();
        for (String split : this.name.split(",\\s*")) {
            if (split.startsWith("-")) {
                negative.addAll((Collection)((Object)new StringThing(split.substring(1)).bake()));
                continue;
            }
            if (split.startsWith("+")) {
                positive.addAll((Collection)((Object)new StringThing(split.substring(1)).bake()));
                continue;
            }
            positive.addAll((Collection)((Object)new StringThing(split).bake()));
        }
        if (negative.isEmpty()) {
            return positive;
        }
        if (positive.isEmpty()) {
            return NNList.emptyList();
        }
        return new NNList<IThing>(new ExclusionThing(positive, negative));
    }

    @Override
    public boolean is(@Nullable Item item) {
        return false;
    }

    @Override
    public boolean is(@Nullable ItemStack itemStack) {
        return false;
    }

    @Override
    public boolean is(@Nullable Block block) {
        return false;
    }

    @Override
    @Nonnull
    public NNList<Item> getItems() {
        return NNList.emptyList();
    }

    @Override
    @Nonnull
    public NNList<ItemStack> getItemStacks() {
        return NNList.emptyList();
    }

    @Override
    @Nonnull
    public NNList<Block> getBlocks() {
        return NNList.emptyList();
    }

    public String toString() {
        return String.format("StringThing [name=%s]", this.name);
    }
}

