/*
 * Decompiled with CFR 0.152.
 */
package worldcontrolteam.worldcontrol.tileentity;

import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileEntityBaseReactorHeatMonitor
extends TileEntity
implements ITickable {
    boolean prevOverheated;
    private int threshhold = 500;
    private boolean outputInverse = false;
    private BlockPos referenceBlock;

    public void func_73660_a() {
        boolean overheated = this.isOverHeated();
        if (this.prevOverheated != overheated) {
            this.prevOverheated = overheated;
            this.markForUpdate();
        }
    }

    public int getThreshhold() {
        return this.threshhold;
    }

    public void setThreshhold(int updateT) {
        if (updateT > 1000000) {
            updateT = 1000000;
        }
        if (updateT < 0) {
            updateT = 0;
        }
        this.threshhold = updateT;
        this.markForUpdate();
    }

    public boolean getInversion() {
        return this.outputInverse;
    }

    public BlockPos getReferenceBlock() {
        return this.referenceBlock;
    }

    public void setReferenceBlock(BlockPos pos) {
        this.referenceBlock = pos;
    }

    public void setInverse(boolean updateInverse) {
        this.outputInverse = updateInverse;
        this.markForUpdate();
    }

    public abstract int getCurrentHeat();

    public abstract boolean isConnectionValid();

    public String getRenderType() {
        return "half_block";
    }

    public boolean isOverHeated() {
        boolean test = false;
        if (this.isConnectionValid()) {
            test = !this.outputInverse ? this.getCurrentHeat() >= this.threshhold : this.getCurrentHeat() <= this.threshhold;
        }
        return test;
    }

    public void markForUpdate() {
        this.field_145850_b.func_175685_c(this.func_174877_v(), this.getBlock(), false);
        this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.field_174879_c), this.func_145831_w().func_180495_p(this.field_174879_c), 3);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound syncData = new NBTTagCompound();
        syncData.func_74768_a("threshold", this.threshhold);
        syncData.func_74757_a("inverted", this.outputInverse);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, syncData);
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.threshhold = pkt.func_148857_g().func_74762_e("threshold");
        this.outputInverse = pkt.func_148857_g().func_74767_n("inverted");
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.threshhold = nbttagcompound.func_74762_e("threshold");
        this.outputInverse = nbttagcompound.func_74767_n("inverted");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        nbttagcompound = super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74757_a("inverted", this.outputInverse);
        nbttagcompound.func_74768_a("threshold", this.threshhold);
        return nbttagcompound;
    }

    public abstract Block getBlock();
}

