/*
 * Decompiled with CFR 0.152.
 */
package worldcontrolteam.worldcontrol.client.model.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.model.TRSRTransformation;
import worldcontrolteam.worldcontrol.client.model.util.TextureArray;

public final class ModelUtil {
    public static Vector4f FULL_FACE_UV = new Vector4f(0.0f, 0.0f, 16.0f, 16.0f);
    public static Vector4f[] FULL_FACES;
    public static Map<ItemCameraTransforms.TransformType, TRSRTransformation> ITEM_TRANSFORMS;
    public static Map<ItemCameraTransforms.TransformType, TRSRTransformation> BLOCK_TRANSFORMS;
    public static Map<ItemCameraTransforms.TransformType, TRSRTransformation> HANDHELD_TRANSFORMS;
    public static TRSRTransformation ITEM_GROUND;
    public static TRSRTransformation ITEM_HEAD;
    public static TRSRTransformation ITEM_THIRD_PERSON_RIGHT;
    public static TRSRTransformation ITEM_THIRD_PERSON_LEFT;
    public static TRSRTransformation ITEM_FIRST_PERSON_RIGHT;
    public static TRSRTransformation ITEM_FIRST_PERSON_LEFT;
    public static TRSRTransformation HANDHELD_THIRD_PERSON_RIGHT;
    public static TRSRTransformation HANDHELD_THIRD_PERSON_LEFT;
    public static TRSRTransformation BLOCK_GUI;
    public static TRSRTransformation BLOCK_GROUND;
    public static TRSRTransformation BLOCK_FIXED;
    public static TRSRTransformation BLOCK_HEAD;
    public static TRSRTransformation BLOCK_THIRD_PERSON_RIGHT;
    public static TRSRTransformation BLOCK_THIRD_PERSON_LEFT;
    public static TRSRTransformation BLOCK_FIRST_PERSON_RIGHT;
    public static TRSRTransformation BLOCK_FIRST_PERSON_LEFT;

    public static TRSRTransformation createTESRTransformation(float translateX, float translateY, float translateZ, float rotateX, float rotateY, float rotateZ, float scale) {
        return ModelUtil.createTESRTransformation(new Vector3f(translateX / 16.0f, translateY / 16.0f, translateZ / 16.0f), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(rotateX, rotateY, rotateZ)), new Vector3f(scale, scale, scale));
    }

    public static TRSRTransformation createTESRTransformation(Vector3f translation, Quat4f rotation, Vector3f scale) {
        return new TRSRTransformation(translation, rotation, scale, null);
    }

    public static ImmutableList<BakedQuad> makeCuboid(VertexFormat format, double x1, double y1, double z1, double x2, double y2, double z2, Vector4f[] uv, TextureArray textureArray, int tintIndex) {
        if (uv == null) {
            uv = FULL_FACES;
        }
        return ImmutableList.of((Object)ModelUtil.makeCubeFace(format, EnumFacing.NORTH, x1, y1, x1, x2, y2, z2, uv[0].x, uv[0].y, uv[0].z, uv[0].w, textureArray.getNorthTexture(), tintIndex), (Object)ModelUtil.makeCubeFace(format, EnumFacing.EAST, x1, y1, x1, x2, y2, z2, uv[1].x, uv[1].y, uv[1].z, uv[1].w, textureArray.getEastTexture(), tintIndex), (Object)ModelUtil.makeCubeFace(format, EnumFacing.SOUTH, x1, y1, x1, x2, y2, z2, uv[2].x, uv[2].y, uv[2].z, uv[2].w, textureArray.getSouthTexture(), tintIndex), (Object)ModelUtil.makeCubeFace(format, EnumFacing.WEST, x1, y1, x1, x2, y2, z2, uv[3].x, uv[3].y, uv[3].z, uv[3].w, textureArray.getWestTexture(), tintIndex), (Object)ModelUtil.makeCubeFace(format, EnumFacing.UP, x1, y1, x1, x2, y2, z2, uv[4].x, uv[4].y, uv[4].z, uv[4].w, textureArray.getUpTexture(), tintIndex), (Object)ModelUtil.makeCubeFace(format, EnumFacing.DOWN, x1, y1, x1, x2, y2, z2, uv[5].x, uv[5].y, uv[5].z, uv[5].w, textureArray.getDownTexture(), tintIndex));
    }

    public static BakedQuad makeCubeFace(VertexFormat format, EnumFacing side, double x1, double y1, double z1, double x2, double y2, double z2, float u, float v, float uw, float vh, TextureAtlasSprite sprite, int tintIndex) {
        switch (side) {
            case NORTH: {
                return ModelUtil.createQuad(format, x1 + x2, y1 + y2, z1, x1 + x2, y1, z1, x1, y1, z1, x1, y1 + y2, z1, u, v, uw, vh, new Vec3d(0.0, 0.0, -1.0), sprite, tintIndex);
            }
            case EAST: {
                return ModelUtil.createQuad(format, x1 + x2, y1 + y2, z1 + z2, x1 + x2, y1, z1 + z2, x1 + x2, y1, z1, x1 + x2, y1 + y2, z1, u, v, uw, vh, new Vec3d(1.0, 0.0, 0.0), sprite, tintIndex);
            }
            case SOUTH: {
                return ModelUtil.createQuad(format, x1, y1 + y2, z1 + z2, x1, y1, z1 + z2, x1 + x2, y1, z1 + z2, x1 + x2, y1 + y2, z1 + z2, u, v, uw, vh, new Vec3d(0.0, 0.0, 1.0), sprite, tintIndex);
            }
            case WEST: {
                return ModelUtil.createQuad(format, x1, y1 + y2, z1, x1, y1, z1, x1, y1, z1 + z2, x1, y1 + y2, z1 + z2, u, v, uw, vh, new Vec3d(-1.0, 0.0, 0.0), sprite, tintIndex);
            }
            case UP: {
                return ModelUtil.createQuad(format, x1, y1 + y2, z1, x1, y1 + y2, z1 + z2, x1 + x2, y1 + y2, z1 + z2, x1 + x2, y1 + y2, z1, u, v, uw, vh, new Vec3d(0.0, 1.0, 0.0), sprite, tintIndex);
            }
            case DOWN: {
                return ModelUtil.createQuad(format, x1 + x2, y1, z1, x1 + x2, y1, z1 + z2, x1, y1, z1 + z2, x1, y1, z1, u, v, uw, vh, new Vec3d(0.0, -1.0, 0.0), sprite, tintIndex);
            }
        }
        return null;
    }

    public static BakedQuad createQuad(VertexFormat format, double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3, double x4, double y4, double z4, float u, float v, float uw, float vh, Vec3d normal, TextureAtlasSprite sprite, int tintIndex) {
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(format);
        builder.setTexture(sprite);
        if (tintIndex > -1) {
            builder.setQuadTint(tintIndex);
        }
        ModelUtil.putVertex(builder, normal, x1, y1, z1, u, v, sprite);
        ModelUtil.putVertex(builder, normal, x2, y2, z2, u, v + vh, sprite);
        ModelUtil.putVertex(builder, normal, x3, y3, z3, u + uw, v + vh, sprite);
        ModelUtil.putVertex(builder, normal, x4, y4, z4, u + uw, v, sprite);
        return builder.build();
    }

    public static void putVertex(UnpackedBakedQuad.Builder builder, Vec3d normal, double x, double y, double z, float u, float v, TextureAtlasSprite sprite) {
        VertexFormat format = builder.getVertexFormat();
        block6: for (int e = 0; e < format.func_177345_h(); ++e) {
            switch (format.func_177348_c(e).func_177375_c()) {
                case POSITION: {
                    builder.put(e, new float[]{(float)x, (float)y, (float)z, 1.0f});
                    continue block6;
                }
                case COLOR: {
                    builder.put(e, new float[]{1.0f, 1.0f, 1.0f, 1.0f});
                    continue block6;
                }
                case UV: {
                    if (format.func_177348_c(e).func_177369_e() != 0) continue block6;
                    u = sprite.func_94214_a((double)u);
                    v = sprite.func_94207_b((double)v);
                    builder.put(e, new float[]{u, v, 0.0f, 1.0f});
                    continue block6;
                }
                case NORMAL: {
                    builder.put(e, new float[]{(float)normal.field_72450_a, (float)normal.field_72448_b, (float)normal.field_72449_c, 0.0f});
                    continue block6;
                }
                default: {
                    builder.put(e, new float[0]);
                }
            }
        }
    }

    static {
        ITEM_TRANSFORMS = Maps.newHashMap();
        BLOCK_TRANSFORMS = Maps.newHashMap();
        HANDHELD_TRANSFORMS = Maps.newHashMap();
        ITEM_GROUND = ModelUtil.createTESRTransformation(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f);
        ITEM_HEAD = ModelUtil.createTESRTransformation(0.0f, 13.0f, 7.0f, 0.0f, 180.0f, 0.0f, 1.0f);
        ITEM_THIRD_PERSON_RIGHT = ModelUtil.createTESRTransformation(0.0f, 3.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.55f);
        ITEM_THIRD_PERSON_LEFT = ModelUtil.createTESRTransformation(0.0f, 3.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.55f);
        ITEM_FIRST_PERSON_RIGHT = ModelUtil.createTESRTransformation(1.13f, 3.2f, 1.13f, 0.0f, -90.0f, 25.0f, 0.68f);
        ITEM_FIRST_PERSON_LEFT = ModelUtil.createTESRTransformation(1.13f, 3.2f, 1.13f, 0.0f, 90.0f, -25.0f, 0.68f);
        HANDHELD_THIRD_PERSON_RIGHT = ModelUtil.createTESRTransformation(0.0f, 4.0f, 0.5f, 0.0f, -90.0f, 55.0f, 0.85f);
        HANDHELD_THIRD_PERSON_LEFT = ModelUtil.createTESRTransformation(0.0f, 4.0f, 0.5f, 0.0f, 90.0f, -55.0f, 0.85f);
        BLOCK_GUI = ModelUtil.createTESRTransformation(0.0f, 0.0f, 0.0f, 30.0f, 225.0f, 0.0f, 0.625f);
        BLOCK_GROUND = ModelUtil.createTESRTransformation(0.0f, 3.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.25f);
        BLOCK_FIXED = ModelUtil.createTESRTransformation(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f);
        BLOCK_HEAD = ModelUtil.createTESRTransformation(0.0f, 13.0f, 7.0f, 0.0f, 180.0f, 0.0f, 1.0f);
        BLOCK_THIRD_PERSON_RIGHT = ModelUtil.createTESRTransformation(0.0f, 2.5f, 0.0f, 75.0f, 45.0f, 0.0f, 0.375f);
        BLOCK_THIRD_PERSON_LEFT = ModelUtil.createTESRTransformation(0.0f, 2.5f, 0.0f, 75.0f, 45.0f, 0.0f, 0.375f);
        BLOCK_FIRST_PERSON_RIGHT = ModelUtil.createTESRTransformation(0.0f, 0.0f, 0.0f, 0.0f, 45.0f, 0.0f, 0.4f);
        BLOCK_FIRST_PERSON_LEFT = ModelUtil.createTESRTransformation(0.0f, 0.0f, 0.0f, 0.0f, 225.0f, 0.0f, 0.4f);
        ITEM_TRANSFORMS.put(ItemCameraTransforms.TransformType.GROUND, ITEM_GROUND);
        ITEM_TRANSFORMS.put(ItemCameraTransforms.TransformType.HEAD, ITEM_HEAD);
        ITEM_TRANSFORMS.put(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, ITEM_THIRD_PERSON_RIGHT);
        ITEM_TRANSFORMS.put(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, ITEM_THIRD_PERSON_LEFT);
        ITEM_TRANSFORMS.put(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, ITEM_FIRST_PERSON_RIGHT);
        ITEM_TRANSFORMS.put(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, ITEM_FIRST_PERSON_LEFT);
        HANDHELD_TRANSFORMS.put(ItemCameraTransforms.TransformType.GROUND, ITEM_GROUND);
        HANDHELD_TRANSFORMS.put(ItemCameraTransforms.TransformType.HEAD, ITEM_HEAD);
        HANDHELD_TRANSFORMS.put(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, HANDHELD_THIRD_PERSON_RIGHT);
        HANDHELD_TRANSFORMS.put(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, HANDHELD_THIRD_PERSON_LEFT);
        HANDHELD_TRANSFORMS.put(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, ITEM_FIRST_PERSON_RIGHT);
        HANDHELD_TRANSFORMS.put(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, ITEM_FIRST_PERSON_LEFT);
        BLOCK_TRANSFORMS.put(ItemCameraTransforms.TransformType.GUI, BLOCK_GUI);
        BLOCK_TRANSFORMS.put(ItemCameraTransforms.TransformType.GROUND, BLOCK_GROUND);
        BLOCK_TRANSFORMS.put(ItemCameraTransforms.TransformType.FIXED, BLOCK_FIXED);
        BLOCK_TRANSFORMS.put(ItemCameraTransforms.TransformType.HEAD, BLOCK_HEAD);
        BLOCK_TRANSFORMS.put(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, BLOCK_THIRD_PERSON_RIGHT);
        BLOCK_TRANSFORMS.put(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, BLOCK_THIRD_PERSON_LEFT);
        BLOCK_TRANSFORMS.put(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, BLOCK_FIRST_PERSON_RIGHT);
        BLOCK_TRANSFORMS.put(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, BLOCK_FIRST_PERSON_LEFT);
        FULL_FACES = new Vector4f[]{FULL_FACE_UV, FULL_FACE_UV, FULL_FACE_UV, FULL_FACE_UV, FULL_FACE_UV, FULL_FACE_UV};
    }
}

