/*
 * Decompiled with CFR 0.152.
 */
package worldcontrolteam.worldcontrol.api.card.property;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import worldcontrolteam.worldcontrol.api.card.property.IPropertyProvider;
import worldcontrolteam.worldcontrol.api.card.property.Property;

public class Properties {
    public Map<String, Optional<Object>> values = new HashMap<String, Optional<Object>>();

    public Properties(IPropertyProvider propertyProvider) {
        for (Property i : propertyProvider.getProperties()) {
            this.values.put(i.getName(), Optional.empty());
        }
    }

    public <T> Properties withValue(Property<T> property, T value) {
        this.values.put(property.getName(), Optional.of(value));
        return this;
    }

    public <T> T getValue(Property<T> property) {
        Optional<Object> optional = this.values.get(property.getName());
        return optional.orElse(null);
    }

    public <T> T getValue(String propertyName) {
        Optional<Object> optional = this.values.get(propertyName);
        return optional.orElse(null);
    }
}

