/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.plugins;

import com.tagnumelite.projecteintegration.api.PEIApi;
import com.tagnumelite.projecteintegration.api.PEIPlugin;
import com.tagnumelite.projecteintegration.api.RegPEIPlugin;
import com.tagnumelite.projecteintegration.api.mappers.PEIMapper;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.FluidStack;
import zmaster587.libVulpes.interfaces.IRecipe;
import zmaster587.libVulpes.recipe.RecipesMachine;

@RegPEIPlugin(modid="libVulpes")
public class PluginLibVulpes
extends PEIPlugin {
    public PluginLibVulpes(String modid, Configuration config) {
        super(modid, config);
    }

    @Override
    public void setup() {
        PEIApi.LOG.debug("RECIPE LIST SIZE: %i", (Object)RecipesMachine.getInstance().recipeList.size());
        for (Class clazz : RecipesMachine.getInstance().recipeList.keySet()) {
            PEIApi.LOG.debug("Adding new mapper from libvuples");
            this.addMapper(new RecipeMapper(clazz));
        }
    }

    protected static class RecipeMapper
    extends PEIMapper {
        private final Class clazz;

        public RecipeMapper(Class clazz) {
            super(clazz.getSimpleName());
            this.clazz = clazz;
        }

        @Override
        public void setup() {
            for (IRecipe recipe : RecipesMachine.getInstance().getRecipes(this.clazz)) {
                boolean no_fluid_out;
                List item_outputs = recipe.getOutput();
                List fluid_outputs = recipe.getFluidOutputs();
                boolean no_item_out = item_outputs == null || item_outputs.isEmpty();
                boolean bl = no_fluid_out = fluid_outputs == null || fluid_outputs.isEmpty();
                if (no_item_out || no_fluid_out) continue;
                if (!no_item_out) {
                    for (ItemStack item : item_outputs) {
                        this.addRecipe(item, recipe.getFluidIngredients().toArray(), recipe.getIngredients().toArray());
                    }
                }
                if (no_fluid_out) continue;
                for (FluidStack fluid : fluid_outputs) {
                    this.addRecipe(fluid, recipe.getFluidIngredients().toArray(), recipe.getIngredients().toArray());
                }
            }
        }
    }
}

