/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.plugins;

import com.enderio.core.common.util.NNList;
import com.google.common.collect.ImmutableMap;
import com.tagnumelite.projecteintegration.api.PEIApi;
import com.tagnumelite.projecteintegration.api.PEIPlugin;
import com.tagnumelite.projecteintegration.api.RegPEIPlugin;
import com.tagnumelite.projecteintegration.api.mappers.PEIMapper;
import crazypants.enderio.base.material.material.Material;
import crazypants.enderio.base.recipe.IMachineRecipe;
import crazypants.enderio.base.recipe.IManyToOneRecipe;
import crazypants.enderio.base.recipe.IRecipe;
import crazypants.enderio.base.recipe.MachineRecipeRegistry;
import crazypants.enderio.base.recipe.Recipe;
import crazypants.enderio.base.recipe.RecipeOutput;
import crazypants.enderio.base.recipe.alloysmelter.AlloyRecipeManager;
import crazypants.enderio.base.recipe.sagmill.SagMillRecipeManager;
import crazypants.enderio.base.recipe.slicensplice.SliceAndSpliceRecipeManager;
import crazypants.enderio.base.recipe.soul.ISoulBinderRecipe;
import crazypants.enderio.base.recipe.vat.VatRecipeManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;

@RegPEIPlugin(modid="enderio")
public class PluginEnderIO
extends PEIPlugin {
    private List<IMachineRecipe> SOULBINDER_RECIPES;

    public PluginEnderIO(String modid, Configuration config) {
        super(modid, config);
    }

    @Override
    public void setup() {
        this.addEMC(Material.POWDER_INFINITY.getStack(), 32);
        this.addEMC(Material.PLANT_BROWN.getStack(), 1);
        this.addEMC(Material.PLANT_GREEN.getStack(), 1);
        this.SOULBINDER_RECIPES = MachineRecipeRegistry.instance.getRecipesForMachine("soulbinder").values().stream().filter(r -> r instanceof ISoulBinderRecipe).collect(Collectors.toList());
        for (IMachineRecipe sbr : this.SOULBINDER_RECIPES) {
            if (!(sbr instanceof ISoulBinderRecipe)) continue;
            for (ResourceLocation resource : ((ISoulBinderRecipe)sbr).getSupportedSouls()) {
                Object soul = PEIApi.getResource(resource);
                if (soul != null) continue;
                int emc = this.config.getInt("emc_soul_" + resource.func_110623_a(), this.category, 0, 0, Integer.MAX_VALUE, "EMC for " + resource.toString());
                PEIApi.addResource(resource, emc);
            }
        }
        this.addMapper(new AlloySmelterMapper());
        this.addMapper(new SagMillMapper());
        this.addMapper(new SliceAndSpliceMapper());
        this.addMapper(new VatMapper());
        this.addMapper(new SoulBinderMapper());
    }

    private class SoulBinderMapper
    extends PEIMapper {
        public SoulBinderMapper() {
            super("Soul Binder");
        }

        private Object getObjectFromSoulList(NNList<ResourceLocation> souls) {
            ArrayList<Object> mapped_souls = new ArrayList<Object>();
            for (ResourceLocation resource : souls) {
                Object soul = PEIApi.getResource(resource);
                if (soul == null) continue;
                mapped_souls.add(soul);
            }
            if (mapped_souls.isEmpty()) {
                return null;
            }
            return PEIApi.getList(mapped_souls);
        }

        @Override
        public void setup() {
            for (IMachineRecipe machine_recipe : PluginEnderIO.this.SOULBINDER_RECIPES) {
                ItemStack input;
                ISoulBinderRecipe recipe;
                ItemStack output;
                if (!(machine_recipe instanceof ISoulBinderRecipe) || (output = (recipe = (ISoulBinderRecipe)machine_recipe).getOutputStack()) == null || output.func_190926_b() || (input = recipe.getInputStack()) == null || input.func_190926_b()) continue;
                Object soul_emc = this.getObjectFromSoulList((NNList<ResourceLocation>)recipe.getSupportedSouls());
                if (soul_emc == null) {
                    this.addConversion(output, (Map<Object, Integer>)ImmutableMap.of((Object)input, (Object)input.func_190916_E()));
                    continue;
                }
                this.addConversion(output, (Map<Object, Integer>)ImmutableMap.of((Object)input, (Object)input.func_190916_E(), (Object)soul_emc, (Object)1));
            }
        }
    }

    private class VatMapper
    extends IRecipeMapper {
        public VatMapper() {
            super("Vat");
        }

        @Override
        public void setup() {
            for (IRecipe recipe : VatRecipeManager.getInstance().getRecipes()) {
                this.addRecipe(recipe);
            }
        }
    }

    private class SliceAndSpliceMapper
    extends ManyToOneRecipeMapper {
        public SliceAndSpliceMapper() {
            super("Slice And Splice");
        }

        @Override
        public void setup() {
            for (IManyToOneRecipe recipe : SliceAndSpliceRecipeManager.getInstance().getRecipes()) {
                this.addRecipe(recipe);
            }
        }
    }

    private class SagMillMapper
    extends IRecipeMapper {
        public SagMillMapper() {
            super("Sag Mill");
        }

        @Override
        public void setup() {
            for (Recipe recipe : SagMillRecipeManager.getInstance().getRecipes()) {
                this.addRecipe((IRecipe)recipe);
            }
        }
    }

    private class AlloySmelterMapper
    extends ManyToOneRecipeMapper {
        public AlloySmelterMapper() {
            super("Alloy Smelter");
        }

        @Override
        public void setup() {
            for (IManyToOneRecipe recipe : AlloyRecipeManager.getInstance().getRecipes()) {
                this.addRecipe(recipe);
            }
        }
    }

    private abstract class ManyToOneRecipeMapper
    extends PEIMapper {
        public ManyToOneRecipeMapper(String name) {
            super(name);
        }

        protected void addRecipe(IManyToOneRecipe recipe) {
            this.addRecipe(recipe.getOutput(), recipe.getInputFluidStacks().toArray(), recipe.getInputStackAlternatives().toArray());
        }
    }

    private abstract class IRecipeMapper
    extends PEIMapper {
        public IRecipeMapper(String name) {
            super(name);
        }

        protected void addRecipe(IRecipe recipe) {
            for (RecipeOutput output : recipe.getOutputs()) {
                if (output.getChance() < 1.0f || !output.isValid()) continue;
                if (output.getFluidOutput() != null) {
                    this.addRecipe(output.getFluidOutput(), recipe.getInputFluidStacks().toArray(), recipe.getInputStackAlternatives().toArray());
                }
                if (output.getOutput() == null) continue;
                this.addRecipe(output.getOutput(), recipe.getInputFluidStacks().toArray(), recipe.getInputStackAlternatives().toArray());
            }
        }
    }
}

