/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.items.blocks;

import com.agricraft.agricore.core.AgriCore;
import com.infinityraider.agricraft.items.blocks.ItemBlockCustomWood;
import com.infinityraider.agricraft.tiles.decoration.TileEntityGrate;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBlockGrate
extends ItemBlockCustomWood {
    public ItemBlockGrate(Block block) {
        super(block);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        tooltip.add(AgriCore.getTranslator().translate("agricraft_tooltip.grate"));
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        if (player == null) {
            return false;
        }
        if (super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState)) {
            TileEntityGrate grate = (TileEntityGrate)world.func_175625_s(pos);
            if (side.func_176740_k().func_176722_c()) {
                ItemBlockGrate.setOffsetOrientation(grate, hitX, hitY, hitZ, EnumFacing.Axis.Y);
            } else {
                ItemBlockGrate.setOffsetOrientation(grate, hitX, hitY, hitZ, player.func_174811_aO().func_176740_k());
            }
            return true;
        }
        return false;
    }

    private static void setOffsetOrientation(TileEntityGrate grate, float hitX, float hitY, float hitZ, EnumFacing.Axis axis) {
        grate.setAxis(axis);
        float hit = ItemBlockGrate.getAxialValue(axis, hitX, hitY, hitZ);
        if (hit <= 0.3333f) {
            grate.setOffset(TileEntityGrate.EnumOffset.NEAR);
        } else if (hit <= 0.6666f) {
            grate.setOffset(TileEntityGrate.EnumOffset.CENTER);
        } else {
            grate.setOffset(TileEntityGrate.EnumOffset.FAR);
        }
    }

    private static float getAxialValue(@Nonnull EnumFacing.Axis axis, float x, float y, float z) {
        switch (axis) {
            case X: {
                return x;
            }
            case Y: {
                return y;
            }
            case Z: {
                return z;
            }
        }
        throw new NullPointerException();
    }
}

