/*
 * Decompiled with CFR 0.152.
 */
package tehseph.netherfoundation.proxy;

import cofh.thermalfoundation.init.TFBlocks;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import slimeknights.tconstruct.shared.TinkerCommons;
import tehseph.netherfoundation.init.NFBlocks;
import tehseph.netherfoundation.init.NFCompat;
import tehseph.netherfoundation.init.NFConfig;
import tehseph.netherfoundation.init.NFEntities;
import tehseph.netherfoundation.init.NFRecipes;

public class CommonProxy {
    public void preInit(FMLPreInitializationEvent event) {
        NFConfig.preInitCommon(event.getSuggestedConfigurationFile());
        NFBlocks.preInitCommon();
        NFEntities.preInitCommon();
        NFCompat.preInitCommon();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void init(FMLInitializationEvent event) {
        NFRecipes.initCommon();
    }

    public void postInit(FMLPostInitializationEvent event) {
        NFConfig.postInitCommon();
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        boolean silktouch = this.hasEnchant(event.getPlayer(), Enchantments.field_185306_r);
        boolean fortune = this.hasEnchant(event.getPlayer(), Enchantments.field_185308_t);
        World world = event.getWorld();
        BlockPos blockPos = event.getPos();
        IBlockState blockState = event.getState();
        EntityPlayer player = event.getPlayer();
        if (NFConfig.ANGRY_PIGMEN && this.isNetherOre(blockState) && (!silktouch || !NFConfig.ANGRY_PIGMEN_SILKTOUCH)) {
            this.angerPigmen(world, blockPos, player);
        }
        if (NFConfig.EXPLOSIONS && this.isNetherOre(blockState) && !player.func_184812_l_()) {
            int multi;
            int n = multi = NFConfig.EXPLOSIONS_FORTUNE && fortune ? 2 : 1;
            if (!(silktouch && NFConfig.EXPLOSIONS_SILKTOUCH || !(world.field_73012_v.nextDouble() <= NFConfig.EXPLOSIONS_CHANCE * (double)multi))) {
                world.func_72876_a((Entity)player, (double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p(), (float)NFConfig.EXPLOSIONS_STRENGTH, true);
            }
        }
    }

    private void angerPigmen(World world, BlockPos blockPos, EntityPlayer player) {
        BlockPos start = new BlockPos((Vec3i)blockPos).func_177982_a(-NFConfig.ANGRY_PIGMEN_RANGE, -NFConfig.ANGRY_PIGMEN_RANGE, -NFConfig.ANGRY_PIGMEN_RANGE);
        BlockPos end = new BlockPos((Vec3i)blockPos).func_177982_a(NFConfig.ANGRY_PIGMEN_RANGE, NFConfig.ANGRY_PIGMEN_RANGE, NFConfig.ANGRY_PIGMEN_RANGE);
        AxisAlignedBB aabb = new AxisAlignedBB(start, end);
        List list = world.func_72872_a(EntityPigZombie.class, aabb);
        for (EntityPigZombie pigman : list) {
            pigman.func_70604_c((EntityLivingBase)player);
        }
    }

    private boolean hasEnchant(EntityPlayer player, Enchantment enchant) {
        if (player == null || player.func_184614_ca().func_190926_b()) {
            return false;
        }
        NBTTagList list = player.func_184614_ca().func_77986_q();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            short enchantId = list.func_150305_b(i).func_74765_d("id");
            if (Enchantment.func_185262_c((int)enchantId) != enchant) continue;
            return true;
        }
        return false;
    }

    private boolean isNetherOre(IBlockState blockState) {
        if (Loader.isModLoaded((String)"tconstruct") && blockState.func_177230_c() == TinkerCommons.blockOre) {
            return true;
        }
        if (blockState == TFBlocks.blockOreFluid.func_176203_a(3)) {
            return true;
        }
        if (blockState.func_177230_c() == NFBlocks.NETHER_ORE) {
            return true;
        }
        return blockState.func_177230_c() == Blocks.field_150449_bY;
    }
}

