/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.joml.Math;
import org.joml.MemUtil;
import org.joml.Options;
import org.joml.Vector2ic;
import org.joml.Vector3ic;
import org.joml.Vector4ic;

public class Vector4i
implements Externalizable,
Vector4ic {
    private static final long serialVersionUID = 1L;
    public int x;
    public int y;
    public int z;
    public int w;

    public Vector4i() {
        this.w = 1;
    }

    public Vector4i(Vector4ic v) {
        if (v instanceof Vector4i) {
            MemUtil.INSTANCE.copy((Vector4i)v, this);
        } else {
            this.x = v.x();
            this.y = v.y();
            this.z = v.z();
            this.w = v.w();
        }
    }

    public Vector4i(Vector3ic v, int w) {
        this.x = v.x();
        this.y = v.y();
        this.z = v.z();
        this.w = w;
    }

    public Vector4i(Vector2ic v, int z, int w) {
        this.x = v.x();
        this.y = v.y();
        this.z = z;
        this.w = w;
    }

    public Vector4i(int s) {
        MemUtil.INSTANCE.broadcast(s, this);
    }

    public Vector4i(int x, int y, int z, int w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public Vector4i(ByteBuffer buffer) {
        this(buffer.position(), buffer);
    }

    public Vector4i(int index, ByteBuffer buffer) {
        MemUtil.INSTANCE.get(this, index, buffer);
    }

    public Vector4i(IntBuffer buffer) {
        this(buffer.position(), buffer);
    }

    public Vector4i(int index, IntBuffer buffer) {
        MemUtil.INSTANCE.get(this, index, buffer);
    }

    public int x() {
        return this.x;
    }

    public int y() {
        return this.y;
    }

    public int z() {
        return this.z;
    }

    public int w() {
        return this.w;
    }

    public Vector4i set(Vector4ic v) {
        if (v instanceof Vector4i) {
            MemUtil.INSTANCE.copy((Vector4i)v, this);
        } else {
            this.x = v.x();
            this.y = v.y();
            this.z = v.z();
            this.w = v.w();
        }
        return this;
    }

    public Vector4i set(Vector3ic v, int w) {
        this.x = v.x();
        this.y = v.y();
        this.z = v.z();
        this.w = w;
        return this;
    }

    public Vector4i set(Vector2ic v, int z, int w) {
        this.x = v.x();
        this.y = v.y();
        this.z = z;
        this.w = w;
        return this;
    }

    public Vector4i set(int s) {
        MemUtil.INSTANCE.broadcast(s, this);
        return this;
    }

    public Vector4i set(int x, int y, int z, int w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
        return this;
    }

    public Vector4i set(ByteBuffer buffer) {
        return this.set(buffer.position(), buffer);
    }

    public Vector4i set(int index, ByteBuffer buffer) {
        MemUtil.INSTANCE.get(this, index, buffer);
        return this;
    }

    public Vector4i set(IntBuffer buffer) {
        return this.set(buffer.position(), buffer);
    }

    public Vector4i set(int index, IntBuffer buffer) {
        MemUtil.INSTANCE.get(this, index, buffer);
        return this;
    }

    public Vector4i setComponent(int component, int value) throws IllegalArgumentException {
        switch (component) {
            case 0: {
                this.x = value;
                break;
            }
            case 1: {
                this.y = value;
                break;
            }
            case 2: {
                this.z = value;
                break;
            }
            case 3: {
                this.w = value;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return this;
    }

    public IntBuffer get(IntBuffer buffer) {
        return this.get(buffer.position(), buffer);
    }

    public IntBuffer get(int index, IntBuffer buffer) {
        MemUtil.INSTANCE.put(this, index, buffer);
        return buffer;
    }

    public ByteBuffer get(ByteBuffer buffer) {
        return this.get(buffer.position(), buffer);
    }

    public ByteBuffer get(int index, ByteBuffer buffer) {
        MemUtil.INSTANCE.put(this, index, buffer);
        return buffer;
    }

    public Vector4i sub(Vector4ic v) {
        this.x -= v.x();
        this.y -= v.y();
        this.z -= v.z();
        this.w -= v.w();
        return this;
    }

    public Vector4i sub(int x, int y, int z, int w) {
        this.x -= x;
        this.y -= y;
        this.z -= z;
        this.w -= w;
        return this;
    }

    public Vector4i sub(Vector4ic v, Vector4i dest) {
        dest.x = this.x - v.x();
        dest.y = this.y - v.y();
        dest.z = this.z - v.z();
        dest.w = this.w - v.w();
        return dest;
    }

    public Vector4i sub(int x, int y, int z, int w, Vector4i dest) {
        dest.x = this.x - x;
        dest.y = this.y - y;
        dest.z = this.z - z;
        dest.w = this.w - w;
        return dest;
    }

    public Vector4i add(Vector4ic v) {
        this.x += v.x();
        this.y += v.y();
        this.z += v.z();
        this.w += v.w();
        return this;
    }

    public Vector4i add(Vector4ic v, Vector4i dest) {
        dest.x = this.x + v.x();
        dest.y = this.y + v.y();
        dest.z = this.z + v.z();
        dest.w = this.w + v.w();
        return dest;
    }

    public Vector4i add(int x, int y, int z, int w) {
        this.x += x;
        this.y += y;
        this.z += z;
        this.w += w;
        return this;
    }

    public Vector4i add(int x, int y, int z, int w, Vector4i dest) {
        dest.x = this.x + x;
        dest.y = this.y + y;
        dest.z = this.z + z;
        dest.w = this.w + w;
        return dest;
    }

    public Vector4i mul(Vector4ic v) {
        this.x *= v.x();
        this.y *= v.y();
        this.z *= v.z();
        this.w *= v.w();
        return this;
    }

    public Vector4i mul(Vector4ic v, Vector4i dest) {
        dest.x = this.x * v.x();
        dest.y = this.y * v.y();
        dest.z = this.z * v.z();
        dest.w = this.w * v.w();
        return dest;
    }

    public Vector4i div(Vector4ic v) {
        this.x /= v.x();
        this.y /= v.y();
        this.z /= v.z();
        this.w /= v.w();
        return this;
    }

    public Vector4i div(Vector4ic v, Vector4i dest) {
        dest.x = this.x / v.x();
        dest.y = this.y / v.y();
        dest.z = this.z / v.z();
        dest.w = this.w / v.w();
        return dest;
    }

    public Vector4i mul(float scalar) {
        this.x = (int)((float)this.x * scalar);
        this.y = (int)((float)this.y * scalar);
        this.z = (int)((float)this.z * scalar);
        this.w = (int)((float)this.w * scalar);
        return this;
    }

    public Vector4i mul(float scalar, Vector4i dest) {
        dest.x = (int)((float)this.x * scalar);
        dest.y = (int)((float)this.y * scalar);
        dest.z = (int)((float)this.z * scalar);
        dest.w = (int)((float)this.w * scalar);
        return dest;
    }

    public Vector4i div(int scalar) {
        this.x /= scalar;
        this.y /= scalar;
        this.z /= scalar;
        this.w /= scalar;
        return this;
    }

    public Vector4i div(float scalar, Vector4i dest) {
        dest.x = (int)((float)this.x / scalar);
        dest.y = (int)((float)this.y / scalar);
        dest.z = (int)((float)this.z / scalar);
        dest.w = (int)((float)this.w / scalar);
        return dest;
    }

    public long lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
    }

    public double length() {
        return Math.sqrt(this.lengthSquared());
    }

    public double distance(Vector4ic v) {
        return Math.sqrt(this.distanceSquared(v));
    }

    public double distance(int x, int y, int z, int w) {
        return Math.sqrt(this.distanceSquared(x, y, z, w));
    }

    public int distanceSquared(Vector4ic v) {
        int dx = this.x - v.x();
        int dy = this.y - v.y();
        int dz = this.z - v.z();
        int dw = this.w - v.w();
        return dx * dx + dy * dy + dz * dz + dw * dw;
    }

    public int distanceSquared(int x, int y, int z, int w) {
        int dx = this.x - x;
        int dy = this.y - y;
        int dz = this.z - z;
        int dw = this.w - w;
        return dx * dx + dy * dy + dz * dz + dw * dw;
    }

    public int dot(Vector4ic v) {
        return this.x * v.x() + this.y * v.y() + this.z * v.z() + this.w * v.w();
    }

    public Vector4i zero() {
        MemUtil.INSTANCE.zero(this);
        return this;
    }

    public Vector4i negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        this.w = -this.w;
        return this;
    }

    public Vector4i negate(Vector4i dest) {
        dest.x = -this.x;
        dest.y = -this.y;
        dest.z = -this.z;
        dest.w = -this.w;
        return dest;
    }

    public String toString() {
        DecimalFormat formatter = new DecimalFormat(" 0.000E0;-");
        String str = this.toString(formatter);
        StringBuffer res = new StringBuffer();
        int eIndex = Integer.MIN_VALUE;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == 'E') {
                eIndex = i;
            } else {
                if (c == ' ' && eIndex == i - 1) {
                    res.append('+');
                    continue;
                }
                if (Character.isDigit(c) && eIndex == i - 1) {
                    res.append('+');
                }
            }
            res.append(c);
        }
        return res.toString();
    }

    public String toString(NumberFormat formatter) {
        return "(" + formatter.format(this.x) + " " + formatter.format(this.y) + " " + formatter.format(this.z) + " " + formatter.format(this.w) + ")";
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.x);
        out.writeInt(this.y);
        out.writeInt(this.z);
        out.writeInt(this.w);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.x = in.readInt();
        this.y = in.readInt();
        this.z = in.readInt();
        this.w = in.readInt();
    }

    public Vector4i min(Vector4ic v) {
        this.x = Math.min(this.x, v.x());
        this.y = Math.min(this.y, v.y());
        this.z = Math.min(this.z, v.z());
        this.w = Math.min(this.w, v.w());
        return this;
    }

    public Vector4i max(Vector4ic v) {
        this.x = Math.max(this.x, v.x());
        this.y = Math.max(this.y, v.y());
        this.z = Math.max(this.z, v.z());
        this.w = Math.min(this.w, v.w());
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        result = 31 * result + this.z;
        result = 31 * result + this.w;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vector4i other = (Vector4i)obj;
        if (this.x != other.x) {
            return false;
        }
        if (this.y != other.y) {
            return false;
        }
        if (this.z != other.z) {
            return false;
        }
        return this.w == other.w;
    }

    public Vector4ic toImmutable() {
        if (!Options.DEBUG) {
            return this;
        }
        return new Proxy(this);
    }

    private final class Proxy
    implements Vector4ic {
        private final Vector4ic delegate;

        Proxy(Vector4ic delegate) {
            this.delegate = delegate;
        }

        public int x() {
            return this.delegate.x();
        }

        public int y() {
            return this.delegate.y();
        }

        public int z() {
            return this.delegate.z();
        }

        public int w() {
            return this.delegate.w();
        }

        public IntBuffer get(IntBuffer buffer) {
            return this.delegate.get(buffer);
        }

        public IntBuffer get(int index, IntBuffer buffer) {
            return this.delegate.get(index, buffer);
        }

        public ByteBuffer get(ByteBuffer buffer) {
            return this.delegate.get(buffer);
        }

        public ByteBuffer get(int index, ByteBuffer buffer) {
            return this.delegate.get(index, buffer);
        }

        public Vector4i sub(Vector4ic v, Vector4i dest) {
            return this.delegate.sub(v, dest);
        }

        public Vector4i sub(int x, int y, int z, int w, Vector4i dest) {
            return this.delegate.sub(x, y, z, w, dest);
        }

        public Vector4i add(Vector4ic v, Vector4i dest) {
            return this.delegate.add(v, dest);
        }

        public Vector4i add(int x, int y, int z, int w, Vector4i dest) {
            return this.delegate.add(x, y, z, w, dest);
        }

        public Vector4i mul(Vector4ic v, Vector4i dest) {
            return this.delegate.mul(v, dest);
        }

        public Vector4i div(Vector4ic v, Vector4i dest) {
            return this.delegate.div(v, dest);
        }

        public Vector4i mul(float scalar, Vector4i dest) {
            return this.delegate.mul(scalar, dest);
        }

        public Vector4i div(float scalar, Vector4i dest) {
            return this.delegate.div(scalar, dest);
        }

        public long lengthSquared() {
            return this.delegate.lengthSquared();
        }

        public double length() {
            return this.delegate.length();
        }

        public double distance(Vector4ic v) {
            return this.delegate.distance(v);
        }

        public double distance(int x, int y, int z, int w) {
            return this.delegate.distance(x, y, z, w);
        }

        public int distanceSquared(Vector4ic v) {
            return this.delegate.distanceSquared(v);
        }

        public int distanceSquared(int x, int y, int z, int w) {
            return this.delegate.distanceSquared(x, y, z, w);
        }

        public int dot(Vector4ic v) {
            return this.delegate.dot(v);
        }

        public Vector4i negate(Vector4i dest) {
            return this.delegate.negate(dest);
        }
    }
}

