/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.network.serialization;

import com.google.common.collect.Sets;
import com.infinityraider.infinitylib.network.serialization.ByteBufUtil;
import com.infinityraider.infinitylib.network.serialization.IMessageReader;
import com.infinityraider.infinitylib.network.serialization.IMessageSerializer;
import com.infinityraider.infinitylib.network.serialization.IMessageWriter;
import com.infinityraider.infinitylib.network.serialization.MessageSerializerArray;
import com.infinityraider.infinitylib.network.serialization.MessageSerializerEnum;
import com.infinityraider.infinitylib.network.serialization.MessageSerializerGeneric;
import com.infinityraider.infinitylib.network.serialization.MessageSerializerSubClass;
import java.util.Optional;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;

public final class MessageSerializerStore {
    private static final Set<IMessageSerializer> SERIALIZERS = Sets.newHashSet();

    public static <T> Optional<IMessageSerializer<T>> getMessageSerializer(Class<T> clazz) {
        for (IMessageSerializer serializer : SERIALIZERS) {
            if (!serializer.accepts(clazz)) continue;
            return Optional.of(serializer);
        }
        return Optional.empty();
    }

    public static <T> void registerMessageSerializer(Class<T> clazz, IMessageWriter<T> writer, IMessageReader<T> reader) {
        MessageSerializerStore.registerMessageSerializer(MessageSerializerGeneric.createSerializer(clazz, writer, reader));
    }

    public static <T> void registerMessageSerializer(IMessageSerializer<T> serializer) {
        SERIALIZERS.add(serializer);
    }

    static {
        MessageSerializerStore.registerMessageSerializer(Boolean.TYPE, ByteBufUtil::writeBoolean, ByteBufUtil::readBoolean);
        MessageSerializerStore.registerMessageSerializer(Boolean.class, ByteBufUtil::writeBoolean, ByteBufUtil::readBoolean);
        MessageSerializerStore.registerMessageSerializer(Byte.TYPE, ByteBufUtil::writeByte, ByteBufUtil::readByte);
        MessageSerializerStore.registerMessageSerializer(Byte.class, ByteBufUtil::writeByte, ByteBufUtil::readByte);
        MessageSerializerStore.registerMessageSerializer(Short.TYPE, ByteBufUtil::writeShort, ByteBufUtil::readShort);
        MessageSerializerStore.registerMessageSerializer(Short.class, ByteBufUtil::writeShort, ByteBufUtil::readShort);
        MessageSerializerStore.registerMessageSerializer(Integer.TYPE, ByteBufUtil::writeInt, ByteBufUtil::readInt);
        MessageSerializerStore.registerMessageSerializer(Integer.class, ByteBufUtil::writeInt, ByteBufUtil::readInt);
        MessageSerializerStore.registerMessageSerializer(Long.TYPE, ByteBufUtil::writeLong, ByteBufUtil::readLong);
        MessageSerializerStore.registerMessageSerializer(Long.class, ByteBufUtil::writeLong, ByteBufUtil::readLong);
        MessageSerializerStore.registerMessageSerializer(Float.TYPE, ByteBufUtil::writeFloat, ByteBufUtil::readFloat);
        MessageSerializerStore.registerMessageSerializer(Float.class, ByteBufUtil::writeFloat, ByteBufUtil::readFloat);
        MessageSerializerStore.registerMessageSerializer(Double.TYPE, ByteBufUtil::writeDouble, ByteBufUtil::readDouble);
        MessageSerializerStore.registerMessageSerializer(Double.class, ByteBufUtil::writeDouble, ByteBufUtil::readDouble);
        MessageSerializerStore.registerMessageSerializer(Character.TYPE, ByteBufUtil::writeChar, ByteBufUtil::readChar);
        MessageSerializerStore.registerMessageSerializer(Character.class, ByteBufUtil::writeChar, ByteBufUtil::readChar);
        MessageSerializerStore.registerMessageSerializer(String.class, ByteBufUtil::writeString, ByteBufUtil::readString);
        MessageSerializerStore.registerMessageSerializer(Entity.class, ByteBufUtil::writeEntity, ByteBufUtil::readEntity);
        MessageSerializerStore.registerMessageSerializer(TileEntity.class, ByteBufUtil::writeTileEntity, ByteBufUtil::readTileEntity);
        MessageSerializerStore.registerMessageSerializer(BlockPos.class, ByteBufUtil::writeBlockPos, ByteBufUtil::readBlockPos);
        MessageSerializerStore.registerMessageSerializer(Block.class, ByteBufUtil::writeBlock, ByteBufUtil::readBlock);
        MessageSerializerStore.registerMessageSerializer(Item.class, ByteBufUtil::writeItem, ByteBufUtil::readItem);
        MessageSerializerStore.registerMessageSerializer(ItemStack.class, ByteBufUtil::writeItemStack, ByteBufUtil::readItemStack);
        MessageSerializerStore.registerMessageSerializer(NBTTagCompound.class, ByteBufUtil::writeNBT, ByteBufUtil::readNBT);
        MessageSerializerStore.registerMessageSerializer(Vec3d.class, ByteBufUtil::writeVec3d, ByteBufUtil::readVec3d);
        MessageSerializerStore.registerMessageSerializer(ITextComponent.class, ByteBufUtil::writeTextComponent, ByteBufUtil::readTextComponent);
        MessageSerializerStore.registerMessageSerializer(MessageSerializerEnum.INSTANCE);
        MessageSerializerStore.registerMessageSerializer(MessageSerializerSubClass.TILE_ENTITY);
        MessageSerializerStore.registerMessageSerializer(MessageSerializerSubClass.ENTITY);
        MessageSerializerStore.registerMessageSerializer(MessageSerializerSubClass.BLOCK);
        MessageSerializerStore.registerMessageSerializer(MessageSerializerSubClass.ITEM);
        MessageSerializerStore.registerMessageSerializer(MessageSerializerSubClass.TEXT);
        MessageSerializerStore.registerMessageSerializer(MessageSerializerArray.INSTANCE);
    }
}

