/*
 * Decompiled with CFR 0.152.
 */
package jackyy.integrationforegoing.integration.straw;

import com.buuz135.industrial.api.straw.StrawHandler;
import com.buuz135.industrial.utils.apihandlers.straw.PotionStrawHandler;
import com.buuz135.industrial.utils.apihandlers.straw.StrawHandlerBase;
import jackyy.integrationforegoing.util.ModConfig;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;

public class StrawRegistryThermalFoundation {
    @SubscribeEvent
    public void register(RegistryEvent.Register<StrawHandler> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register(new StrawHandlerBase("cryotheum"){

            public void onDrink(World world, BlockPos pos, FluidStack stack, EntityPlayer player, boolean fromFluidContainer) {
                player.func_70097_a((DamageSource)new CryotheumDamage(), 15.0f);
                player.func_70066_B();
                player.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 9600, 0));
            }

            class CryotheumDamage
            extends DamageSource {
                CryotheumDamage() {
                    super("cryotheum");
                    this.func_76348_h();
                    this.func_82726_p();
                    this.func_76351_m();
                }
            }
        }.setRegistryName("cryotheum"));
        registry.register(new StrawHandlerBase("ender"){

            public void onDrink(World world, BlockPos pos, FluidStack stack, EntityPlayer player, boolean fromFluidContainer) {
                if (!world.field_72995_K) {
                    double x = player.field_70165_t - (double)MathHelper.func_76125_a((int)ModConfig.misc.thermalFoundation.strawEnderRange, (int)8, (int)65536) + (double)player.field_70170_p.field_73012_v.nextInt(MathHelper.func_76125_a((int)ModConfig.misc.thermalFoundation.strawEnderRange, (int)8, (int)65536) * 2);
                    double y = player.field_70163_u + (double)player.field_70170_p.field_73012_v.nextInt(8);
                    double z = player.field_70161_v - (double)MathHelper.func_76125_a((int)ModConfig.misc.thermalFoundation.strawEnderRange, (int)8, (int)65536) + (double)player.field_70170_p.field_73012_v.nextInt(MathHelper.func_76125_a((int)ModConfig.misc.thermalFoundation.strawEnderRange, (int)8, (int)65536) * 2);
                    EnderTeleportEvent event = new EnderTeleportEvent((EntityLivingBase)player, x, y, z, 0.0f);
                    if (!player.field_70170_p.func_180495_p(new BlockPos(x, y, z)).func_185904_a().func_76220_a()) {
                        player.func_70634_a(event.getTargetX(), event.getTargetY(), event.getTargetZ());
                        player.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
                        player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 60));
                    } else {
                        for (int i = 0; i < 1 + player.field_70170_p.field_73012_v.nextInt(3); ++i) {
                            player.func_70099_a(new ItemStack(Items.field_151079_bi), 0.0f);
                        }
                    }
                }
            }
        }.setRegistryName("ender"));
        registry.register(new StrawHandlerBase("mana"){

            public void onDrink(World world, BlockPos pos, FluidStack stack, EntityPlayer player, boolean fromFluidContainer) {
                player.func_70097_a((DamageSource)new ManaDamage(), 10.0f);
                player.func_70015_d(10);
                player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 1200, 0));
            }

            class ManaDamage
            extends DamageSource {
                ManaDamage() {
                    super("mana");
                    this.func_76348_h();
                    this.func_76351_m();
                }
            }
        }.setRegistryName("mana"));
        registry.register(new StrawHandlerBase("petrotheum"){

            public void onDrink(World world, BlockPos pos, FluidStack stack, EntityPlayer player, boolean fromFluidContainer) {
                player.func_70097_a((DamageSource)new PetrotheumDamage(), 10.0f);
                player.func_70690_d(new PotionEffect(MobEffects.field_76422_e, 6000, 3));
                player.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 6000, 2));
            }

            class PetrotheumDamage
            extends DamageSource {
                PetrotheumDamage() {
                    super("petrotheum");
                    this.func_76348_h();
                    this.func_76351_m();
                }
            }
        }.setRegistryName("petrotheum"));
        registry.register(new StrawHandlerBase("pyrotheum"){

            public void onDrink(World world, BlockPos pos, FluidStack stack, EntityPlayer player, boolean fromFluidContainer) {
                player.func_70097_a((DamageSource)new PyrotheumDamage(), 15.0f);
                player.func_70015_d(60);
                NBTTagCompound tag = player.getEntityData();
                tag.func_74772_a("drankLavaTime", player.field_70170_p.func_82737_E());
            }

            class PyrotheumDamage
            extends DamageSource {
                PyrotheumDamage() {
                    super("pyrotheum");
                    this.func_76348_h();
                    this.func_76361_j();
                    this.func_76351_m();
                }
            }
        }.setRegistryName("pyrotheum"));
        registry.register(new StrawHandlerBase("redstone"){

            public void onDrink(World world, BlockPos pos, FluidStack stack, EntityPlayer player, boolean fromFluidContainer) {
                ArrayList effects = new ArrayList(player.func_70651_bq());
                for (PotionEffect effect : effects) {
                    this.amplifyEffect((EntityLivingBase)player, effect);
                }
                player.func_70015_d(2);
                EntityLightningBolt bolt = new EntityLightningBolt(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), false);
                world.func_72942_c((Entity)bolt);
                world.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), 0.0, 0.0, 0.0, new int[0]);
                world.func_184133_a(null, pos, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }

            private boolean amplifyEffect(EntityLivingBase player, PotionEffect effect) {
                if (effect == null || effect.func_82720_e()) {
                    return false;
                }
                int amplifier = Math.min(effect.func_76458_c() + 1, 3);
                int duration = Math.min(effect.func_76459_b() * 2, 9600);
                player.func_70690_d(new PotionEffect(effect.func_188419_a(), duration, amplifier));
                return true;
            }
        }.setRegistryName("redstone"));
        registry.register(new StrawHandlerBase("steam"){

            public void onDrink(World world, BlockPos pos, FluidStack stack, EntityPlayer player, boolean fromFluidContainer) {
                player.func_70015_d(30);
                player.func_70690_d(new PotionEffect(MobEffects.field_188424_y, 600, 0));
            }
        }.setRegistryName("steam"));
        registry.register(new PotionStrawHandler("aerotheum").addPotion(new PotionEffect(MobEffects.field_76427_o, 4800, 0)).addPotion(new PotionEffect(MobEffects.field_76441_p, 1200, 0)).addPotion(new PotionEffect(MobEffects.field_188424_y, 600, 0)).setRegistryName("aerotheum"));
        registry.register(new PotionStrawHandler("coal").addPotion(new PotionEffect(MobEffects.field_76422_e, 1200, 0)).addPotion(new PotionEffect(MobEffects.field_76440_q, 200, 0)).setRegistryName("coal"));
        registry.register(new PotionStrawHandler("crude_oil").addPotion(new PotionEffect(MobEffects.field_76421_d, 1200, 2)).addPotion(new PotionEffect(MobEffects.field_76440_q, 1200, 0)).setRegistryName("crude_oil"));
        registry.register(new PotionStrawHandler("glowstone").addPotion(new PotionEffect(MobEffects.field_76424_c, 1200, 2)).addPotion(new PotionEffect(MobEffects.field_76430_j, 1200, 2)).addPotion(new PotionEffect(MobEffects.field_76439_r, 1200, 0)).addPotion(new PotionEffect(MobEffects.field_188424_y, 600, 0)).setRegistryName("glowstone"));
    }
}

